package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class CursorListWidget extends class_4265<CursorListWidget.CursorEntry> {
    private static final int ITEM_HEIGHT = 32;
    private static final int SCROLLBAR_OFFSET = 6;
    private static final int ROW_GAP = 1;
    private final CursorOptionsScreen optionsScreen;

    public CursorListWidget(class_310 client, int width, int height, int y, CursorOptionsScreen optionsScreen) {
        super(client, width + SCROLLBAR_OFFSET, height, y, ITEM_HEIGHT + ROW_GAP);
        this.optionsScreen = optionsScreen;
        populateEntries();
    }

    public void populateEntries() {
        for (Cursor cursor : optionsScreen.getCursors()) {
            CursorEntry entry = new CursorEntry(
                    cursor,
                    method_46426(),
                    method_46427() + field_22741 * method_25340(),
                    field_22758 - SCROLLBAR_OFFSET,
                    ITEM_HEIGHT
            );
            this.method_25321(entry);
        }
    }

    @Override
    public int method_25331() {
        return Math.max(0, this.method_25317() - (this.method_55443() - this.method_46427()) + (ROW_GAP * method_25340()) - ROW_GAP);
    }

    @Override
    protected int method_25329() {
        return method_55442() - SCROLLBAR_OFFSET;
    }

    @Override
    protected int method_25337(int index) {
        return this.method_46427() + (this.field_22741 + ROW_GAP) * index - (int) this.method_25341();
    }

    protected int getRowIndex(double y) {
        int index = ((int) Math.floor(y - this.method_46427()) + (int) this.method_25341()) / (this.field_22741 + ROW_GAP);
        return index >= 0 && index < this.method_25340() ? index : -1;
    }

    @Override
    protected @Nullable CursorEntry getEntryAtPosition(double mouseX, double mouseY) {
        int index = this.getRowIndex(mouseY);
        return index >= 0 && this.method_25405(mouseX, mouseY) ? this.method_25326(index) : null;
    }

    @Override
    protected void method_57713(@NotNull class_332 context) {
        // override to remove header and footer
    }

    @Override
    public void method_57715(@NotNull class_332 context) {
        // override to remove background
    }

    public class CursorEntry extends Entry<CursorEntry> {
        public final CursorButtonWidget button;

        public CursorEntry(Cursor cursor, int x, int y, int width, int height) {
            button = new CursorButtonWidget(x, y, width, height, cursor);
        }

        @Override
        public void render(@NotNull class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            button.method_46421(CursorListWidget.this.method_46426());
            button.method_46419(CursorListWidget.this.method_46427() + (field_22741 + ROW_GAP) * index - (int) Math.round(method_25341()));
            button.method_25394(context, mouseX, mouseY, delta);
        }

        @Override
        public @NotNull List<? extends class_6379> narratables() {
            return List.of(button);
        }

        @Override
        public @NotNull List<? extends class_364> children() {
            return List.of(button);
        }
    }

    public class CursorButtonWidget extends class_4264 {
        private static final String PREFIX_TEXT_KEY = "minecraft-cursor.options.cursor-type.";
        private static final int TEXTURE_SIZE = 16;
        private static final int PADDING_LEFT = 8;
        private static final int BACKGROUND_COLOR = 0x7F000000; // black 50%
        private static final int TEXT_COLOR = 0xFFFFFFFF; // white
        private static final int TEXT_DISABLED_COLOR = 0xFF555555; // dark gray
        private static final int BORDER_COLOR = 0xFF000000;
        private static final int SELECTED_BORDER_COLOR = 0xFFFFFFFF; // white
        private static final int HOVERED_BORDER_COLOR = 0xFF555555; // dark gray

        private final Cursor cursor;

        CursorButtonWidget(int x, int y, int width, int height, Cursor cursor) {
            super(x, y, width, height, class_2561.method_43473());
            this.cursor = cursor;
        }

        @Override
        public void method_25306() {
            optionsScreen.selectCursor(cursor);
        }

        @Override
        protected void method_48579(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
            renderBox(context);
            renderTexture(context);
            renderMessage(context);
            renderBorder(context);
        }

        private void renderBorder(class_332 context) {
            int borderColor = BORDER_COLOR;

            if (cursor == optionsScreen.getSelectedCursor()) {
                borderColor = SELECTED_BORDER_COLOR;
            } else if (method_25367()) {
                borderColor = HOVERED_BORDER_COLOR;
            }

            context.method_49601(method_46426(), method_46427(), method_25368(), method_25364(), borderColor);
        }

        private void renderBox(class_332 context) {
            int x2 = method_46426() + method_25368();
            int y2 = method_46427() + method_25364();
            context.method_25294(method_46426(), method_46427(), x2, y2, BACKGROUND_COLOR);
        }

        private void renderTexture(class_332 context) {
            int x = method_46426() + PADDING_LEFT;
            int y = method_46427() + (method_25364() / 2) - (TEXTURE_SIZE / 2);
            optionsScreen.animationHelper.drawSprite(context, cursor, x, y, TEXTURE_SIZE);
        }

        private void renderMessage(class_332 context) {
            class_2561 message = class_2561.method_43471(PREFIX_TEXT_KEY + this.cursor.getType().getKey());
            int color = cursor.isEnabled() ? TEXT_COLOR : TEXT_DISABLED_COLOR;
            int x = method_46426() + TEXTURE_SIZE + PADDING_LEFT * 2;
            int endX = (method_46426() + method_25368()) - SCROLLBAR_OFFSET;
            int endY = method_46427() + method_25364();

            DrawUtil.drawScrollableTextLeftAlign(context, field_22740.field_1772, message, x, method_46427(), endX, endY, color);
        }

        @Override
        protected void method_47399(@NotNull class_6382 builder) {
            // unsupported
        }
    }
}
