package io.github.fishstiz.minecraftcursor.gui.widget;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_5244;

public class SelectedCursorToggleWidget extends class_4185 {
    protected boolean value;
    protected class_2561 prefix;
    protected Consumer<Boolean> handlePress;

    public SelectedCursorToggleWidget(class_2561 prefix, boolean defaultValue, Consumer<Boolean> onPress) {
        this(0, 0, 150, 20, prefix, defaultValue, onPress);
    }

    protected SelectedCursorToggleWidget(
            int x,
            int y,
            int width,
            int height,
            class_2561 prefix,
            boolean defaultValue,
            Consumer<Boolean> onPress
    ) {
        super(x, y, width, height, prefix, SelectedCursorToggleWidget::handlePressButton, class_4185.field_40754);

        this.prefix = prefix;
        this.value = defaultValue;
        this.handlePress = onPress;
        updateMessage();
    }

    protected static void handlePressButton(class_4185 buttonWidget) {
        SelectedCursorToggleWidget toggleWidget = (SelectedCursorToggleWidget) buttonWidget;
        toggleWidget.toggleValue();
        toggleWidget.handlePress.accept(toggleWidget.value);
    }

    protected void toggleValue() {
        value = !value;
        updateMessage();
    }

    public void setValue(boolean value) {
        this.value = value;
        updateMessage();
    }

    protected void updateMessage() {
        method_25355(prefix.method_27661().method_27693(": ").method_10852(value ? class_5244.field_24332 : class_5244.field_24333));
    }

    @Override
    public void method_25357(double mouseX, double mouseY) {
        super.method_25357(mouseX, mouseY);
        method_25365(false);
    }
}
