/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.config.AnimationData;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.cursor.AnimationMode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(AnimationData.Frame.class, (Object)new AnimationData.FrameDeserializer()).registerTypeAdapter(AnimationMode.class, (Object)new AnimationMode.Deserializer()).setPrettyPrinting().create();

    private ConfigLoader() {
    }

    public static AnimationData loadAnimationData(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            AnimationData animationData = (AnimationData)GSON.fromJson((Reader)reader, AnimationData.class);
            return animationData;
        }
    }

    public static Config.Resource loadResource(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            Config.Resource resource = (Config.Resource)GSON.fromJson((Reader)reader, Config.Resource.class);
            return resource;
        }
    }

    public static Config load(File file) {
        Config config = new Config();
        try (FileReader reader = new FileReader(file);){
            config = (Config)GSON.fromJson((Reader)reader, Config.class);
        }
        catch (FileNotFoundException e) {
            MinecraftCursor.LOGGER.info("[minecraft-cursor] Creating config file at '{}'...", (Object)file.getPath());
            ConfigLoader.save(file, config);
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load config at '{}'", (Object)file.getPath());
        }
        config.file = file;
        return config;
    }

    public static void save(File file, Config config) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to save config file at '{}'", (Object)file.getPath());
        }
    }
}

