/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.CursorResourceLoader;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.util.NativeImageUtil;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryUtil;

public class Cursor {
    private static final String IMG_TYPE = ".png";
    @Nullable
    private final Consumer<Cursor> onLoad;
    private final CursorType type;
    private final class_2960 location;
    private final boolean editable;
    private class_2561 text;
    private byte[] pixels;
    private double scale;
    private int xhot;
    private int yhot;
    private boolean enabled;
    private boolean loaded;
    private int textureWidth;
    private int textureHeight;
    private long id = 0L;
    private volatile boolean lazy;

    Cursor(CursorType type, @Nullable Consumer<Cursor> onLoad, boolean editable) {
        this.type = type;
        this.onLoad = onLoad;
        this.location = CursorResourceLoader.getDirectory().method_48331(type.getKey() + IMG_TYPE);
        this.editable = editable;
    }

    Cursor(CursorType type, @Nullable Consumer<Cursor> onLoad) {
        this(type, onLoad, true);
    }

    protected Cursor(Cursor cursor, boolean editable) {
        this(cursor.type, cursor.onLoad, editable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadImage(@NotNull class_1011 image, Config.Settings settings) throws IOException {
        try {
            int imageWidth = image.method_4307();
            int imageHeight = image.method_4323();
            SettingsUtil.assertImageSize(imageWidth, imageHeight);
            try (class_1011 croppedImage = null;){
                if (imageHeight > imageWidth) {
                    croppedImage = NativeImageUtil.cropImage(image, 0, 0, imageWidth, imageWidth);
                }
                class_1011 validImage = croppedImage != null ? croppedImage : image;
                this.create(validImage, settings.getScale(), settings.getXHot(), settings.getYHot());
                this.enabled = settings.isEnabled();
                this.textureWidth = imageWidth;
                this.textureHeight = imageHeight;
                if (this.editable) {
                    this.pixels = NativeImageUtil.getBytes(validImage);
                }
            }
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    protected void updateImage(double scale, int xhot, int yhot) {
        if (!this.editable || !this.isLoaded() || this.pixels == null) {
            return;
        }
        try (class_1011 image = class_1011.method_49277((byte[])this.pixels);){
            this.create(image, scale, xhot, yhot);
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.error("Error updating image of {}: {}", (Object)this.type, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(class_1011 image, double scale, int xhot, int yhot) {
        ByteBuffer pixels;
        long newId;
        long previousId;
        long glfwImageAddress;
        block16: {
            class_1011 scaledImage;
            block14: {
                block15: {
                    scale = SettingsUtil.sanitizeScale(scale);
                    xhot = SettingsUtil.sanitizeHotspot(xhot, image.method_4307());
                    yhot = SettingsUtil.sanitizeHotspot(yhot, image.method_4307());
                    double autoScaled = SettingsUtil.getAutoScale(scale);
                    glfwImageAddress = 0L;
                    previousId = this.id;
                    newId = 0L;
                    pixels = null;
                    scaledImage = null;
                    try {
                        class_1011 validImage = image;
                        if (scale != 1.0) {
                            validImage = scaledImage = NativeImageUtil.scaleImage(image, autoScaled);
                        }
                        int scaledXHot = scale == 1.0 ? xhot : (int)Math.round((double)xhot * autoScaled);
                        int scaledYHot = scale == 1.0 ? yhot : (int)Math.round((double)yhot * autoScaled);
                        int scaledWidth = validImage.method_4307();
                        int scaledHeight = validImage.method_4323();
                        GLFWImage glfwImage = GLFWImage.create();
                        pixels = MemoryUtil.memAlloc((int)(scaledWidth * scaledHeight * 4));
                        NativeImageUtil.writePixelsRGBA(validImage, pixels);
                        glfwImage.set(scaledWidth, scaledHeight, pixels);
                        glfwImageAddress = glfwImage.address();
                        ExternalCursorTracker.trackInternalCursor(glfwImageAddress);
                        newId = GLFW.glfwCreateCursor((GLFWImage)glfwImage, (int)scaledXHot, (int)scaledYHot);
                        if (newId != 0L) break block14;
                        MinecraftCursor.LOGGER.error("[minecraft-cursor] Error creating cursor '{}'. ", (Object)this.type.getKey());
                        if (scaledImage == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (scaledImage != null) {
                            scaledImage.close();
                        }
                        if (pixels != null) {
                            MemoryUtil.memFree(pixels);
                        }
                        if (previousId != 0L && newId != 0L && newId != previousId) {
                            GLFW.glfwDestroyCursor((long)previousId);
                        }
                        if (glfwImageAddress != 0L) {
                            ExternalCursorTracker.consumeInternalCursor(glfwImageAddress);
                        }
                        throw throwable;
                    }
                    scaledImage.close();
                }
                if (pixels != null) {
                    MemoryUtil.memFree((Buffer)pixels);
                }
                if (previousId != 0L && newId != 0L && newId != previousId) {
                    GLFW.glfwDestroyCursor((long)previousId);
                }
                if (glfwImageAddress != 0L) {
                    ExternalCursorTracker.consumeInternalCursor(glfwImageAddress);
                }
                return;
            }
            this.loaded = true;
            this.id = newId;
            this.scale = scale;
            this.xhot = xhot;
            this.yhot = yhot;
            this.notifyOnLoad();
            if (scaledImage == null) break block16;
            scaledImage.close();
        }
        if (pixels != null) {
            MemoryUtil.memFree((Buffer)pixels);
        }
        if (previousId != 0L && newId != 0L && newId != previousId) {
            GLFW.glfwDestroyCursor((long)previousId);
        }
        if (glfwImageAddress != 0L) {
            ExternalCursorTracker.consumeInternalCursor(glfwImageAddress);
        }
    }

    public void destroy() {
        if (this.id != 0L) {
            GLFW.glfwDestroyCursor((long)this.id);
            this.id = 0L;
        }
        if (this.pixels != null) {
            this.pixels = null;
        }
    }

    protected void notifyOnLoad() {
        if (this.onLoad != null) {
            this.onLoad.accept(this);
        }
    }

    public void reload() {
        if (this.isLoaded()) {
            this.updateImage(this.getScale(), this.getXHot(), this.getYHot());
        }
    }

    public void apply(Config.Settings settings) {
        this.enable(settings.isEnabled());
        this.updateImage(settings.getScale(), settings.getXHot(), settings.getYHot());
    }

    public void enable(boolean enabled) {
        boolean previous = this.enabled;
        this.enabled = enabled;
        if (previous != this.enabled && this.isLoaded()) {
            this.notifyOnLoad();
        }
    }

    public class_2960 getLocation() {
        return this.location;
    }

    public long getId() {
        return this.enabled ? this.id : 0L;
    }

    @NotNull
    public CursorType getType() {
        return this.type;
    }

    @NotNull
    public String getTypeKey() {
        return this.type.getKey();
    }

    @NotNull
    public class_2561 getText() {
        if (this.text == null) {
            this.text = class_2561.method_43471((String)("minecraft-cursor.options.cursor-type." + this.type.getKey()));
        }
        return this.text;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.updateImage(scale, this.xhot, this.yhot);
    }

    public int getXHot() {
        return this.xhot;
    }

    public void setXHot(double xhot) {
        this.setXHot((int)xhot);
    }

    public void setXHot(int xhot) {
        this.updateImage(this.scale, xhot, this.yhot);
    }

    public int getYHot() {
        return this.yhot;
    }

    public void setYHot(double yhot) {
        this.setYHot((int)yhot);
    }

    public void setYHot(int yhot) {
        this.updateImage(this.scale, this.xhot, yhot);
    }

    public boolean isEnabled() {
        return this.enabled && this.isLoaded();
    }

    public boolean isLoaded() {
        return this.loaded && this.id != 0L;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public int getTextureIndex() {
        return 0;
    }

    public int getTextureWidth() throws IllegalStateException {
        this.assertLoaded();
        return this.textureWidth;
    }

    public int getTextureHeight() throws IllegalStateException {
        this.assertLoaded();
        return this.textureHeight;
    }

    private void assertLoaded() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Cursor has not been loaded");
        }
    }

    static Cursor createDummy() {
        return new Cursor(CursorType.of((String)""), null);
    }
}

