/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor.resolver;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorHandler;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.ElementRegistrar;
import io.github.fishstiz.minecraftcursor.cursor.handler.InternalCursorProvider;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementInspector;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementInspectorImpl;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementWalker;
import io.github.fishstiz.minecraftcursor.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_364;
import net.minecraft.class_4069;

public final class CursorTypeResolver
implements ElementRegistrar {
    public static final CursorTypeResolver INSTANCE = new CursorTypeResolver();
    private final List<ElementEntry<?>> registry = new ArrayList();
    private final Map<Class<?>, ElementRegistrar.CursorTypeFunction<?>> cache = new Object2ObjectOpenHashMap();
    private ElementInspector inspector = ElementInspector.NO_OP;
    private String lastFailedElement;

    private CursorTypeResolver() {
    }

    public <T extends class_364> void register(CursorHandler<T> cursorHandler) {
        CursorHandler.TargetElement targetElement = cursorHandler.getTargetElement();
        Objects.requireNonNull(targetElement);
        CursorHandler.TargetElement targetElement2 = targetElement;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CursorHandler.TargetElement.ClassRef.class, CursorHandler.TargetElement.NameRef.class}, (Object)targetElement2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Class clazz;
                CursorHandler.TargetElement.ClassRef classRef = (CursorHandler.TargetElement.ClassRef)targetElement2;
                Class elementClass = clazz = classRef.elementClass();
                this.register((Class<T>)elementClass, (ElementRegistrar.CursorTypeFunction<T>)cursorHandler);
                break;
            }
            case 1: {
                CursorHandler.TargetElement.NameRef nameRef = (CursorHandler.TargetElement.NameRef)targetElement2;
                try {
                    String string;
                    String className = string = nameRef.className();
                    this.register(className, (ElementRegistrar.CursorTypeFunction<T>)cursorHandler);
                    break;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
    }

    public <T extends class_364> void register(String className, ElementRegistrar.CursorTypeFunction<T> cursorTypeFunction) {
        try {
            Class<?> elementClass = Class.forName(Services.PLATFORM.mapClassName("intermediary", className));
            if (!class_364.class.isAssignableFrom(elementClass)) {
                throw new ClassCastException(className + " is not an Element");
            }
            this.register(elementClass, cursorTypeFunction);
        }
        catch (ClassNotFoundException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Error registering element. Class not found: {}", (Object)className);
        }
        catch (ClassCastException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Error registering element. Invalid class: {}", (Object)e.getMessage());
        }
    }

    public <T extends class_364> void register(Class<T> elementClass, ElementRegistrar.CursorTypeFunction<T> cursorTypeFunction) {
        this.registry.add(new ElementEntry<T>(Objects.requireNonNull(elementClass), Objects.requireNonNull(cursorTypeFunction)));
    }

    public <T extends class_364> void register(Class<T> elementClass, CursorType cursorType) {
        this.register(elementClass, (element, mouseX, mouseY) -> cursorType);
    }

    public CursorType resolve(class_364 element, double mouseX, double mouseY) {
        Class elementClass = element.getClass();
        try {
            CursorType mapped;
            CursorProvider cursorProvider;
            CursorType providedCursorType;
            if (element instanceof CursorProvider && (providedCursorType = (cursorProvider = (CursorProvider)element).getCursorType(mouseX, mouseY)) != null && !providedCursorType.isDefault()) {
                return providedCursorType;
            }
            Object mapper = this.cache.get(elementClass);
            if (mapper == null) {
                mapper = this.resolveMapper(element);
                if (!this.inspector.setProcessed(element, true)) {
                    this.cache.put(elementClass, (ElementRegistrar.CursorTypeFunction<?>)mapper);
                }
            }
            if ((mapped = mapper.getCursorType(element, mouseX, mouseY)) != null && !mapped.isDefault()) {
                return mapped;
            }
            if (element instanceof InternalCursorProvider) {
                InternalCursorProvider internalCursorProvider = (InternalCursorProvider)element;
                this.inspector.setProcessed(element, false);
                return internalCursorProvider.minecraft_cursor$getCursorType(mouseX, mouseY);
            }
            return CursorType.DEFAULT;
        }
        catch (Exception | LinkageError e) {
            String elementName = elementClass.getName();
            if (!elementName.equals(this.lastFailedElement)) {
                this.lastFailedElement = elementName;
                MinecraftCursor.LOGGER.error("Could not get cursor type for element: {}", (Object)Services.PLATFORM.unmapClassName("intermediary", elementName));
            }
            return CursorType.DEFAULT;
        }
    }

    private ElementRegistrar.CursorTypeFunction<? extends class_364> resolveMapper(class_364 element) {
        for (int i = this.registry.size() - 1; i >= 0; --i) {
            if (!this.registry.get((int)i).element.isInstance(element)) continue;
            this.inspector.setProcessed(element, true);
            return this.registry.get((int)i).mapper;
        }
        if (element instanceof class_4069) {
            return this::resolveParent;
        }
        return ElementRegistrar::elementToDefault;
    }

    private CursorType resolveParent(class_4069 parent, double mouseX, double mouseY) {
        return ElementWalker.walk(parent, mouseX, mouseY, this::resolveChild, type -> !type.isDefault(), CursorType.DEFAULT);
    }

    private CursorType resolveChild(class_364 child, double mouseX, double mouseY) {
        this.inspector.setProcessed(child, false);
        return this.resolve(child, mouseX, mouseY);
    }

    public int cacheSize() {
        return this.cache.size();
    }

    public void clearCache() {
        this.cache.clear();
    }

    public ElementInspector getInspector() {
        return this.inspector;
    }

    public void toggleInspector() {
        this.inspector.destroy();
        this.inspector = this.inspector == ElementInspector.NO_OP ? new ElementInspectorImpl() : ElementInspector.NO_OP;
        this.cache.clear();
    }

    private record ElementEntry<T extends class_364>(Class<T> element, ElementRegistrar.CursorTypeFunction<T> mapper) {
    }
}

