/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

sealed interface CursorRenderer {
    public void setCursor(@NotNull Cursor var1);

    public void resetCursor();

    public void render(Minecraft var1, GuiGraphics var2, int var3, int var4);

    public static final class Virtual
    implements CursorRenderer {
        private ResourceLocation textureLocation;
        private int textureWidth;
        private int textureHeight;
        private int vOffset;
        private double xhot;
        private double yhot;
        private double size;

        Virtual() {
        }

        @Override
        public void setCursor(@NotNull Cursor cursor) {
            this.textureLocation = cursor.getLocation();
            this.textureWidth = cursor.getTextureWidth();
            this.textureHeight = cursor.getTextureHeight();
            this.vOffset = this.textureWidth * cursor.getTextureIndex();
            double scale = SettingsUtil.getAutoScale(cursor.getScale());
            this.xhot = (double)cursor.getXHot() * scale;
            this.yhot = (double)cursor.getYHot() * scale;
            this.size = (double)this.textureWidth * scale;
        }

        @Override
        public void resetCursor() {
            GLFW.glfwSetInputMode((long)CursorTypeUtil.WINDOW, (int)208897, (int)212993);
            this.textureLocation = null;
        }

        @Override
        public void render(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (!minecraft.mouseHandler.isMouseGrabbed() && this.textureLocation != null) {
                int guiScale = minecraft.getWindow().getGuiScale();
                int scaledSize = (int)Math.round(this.size / (double)guiScale);
                int x = mouseX - (int)Math.round(this.xhot / (double)guiScale);
                int y = mouseY - (int)Math.round(this.yhot / (double)guiScale);
                GLFW.glfwSetInputMode((long)CursorTypeUtil.WINDOW, (int)208897, (int)212994);
                guiGraphics.nextStratum();
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.textureLocation, x, y, 0.0f, (float)this.vOffset, scaledSize, scaledSize, this.textureWidth, this.textureWidth, this.textureWidth, this.textureHeight);
            }
        }
    }

    public static final class Native
    implements CursorRenderer {
        Native() {
        }

        @Override
        public void setCursor(@NotNull Cursor cursor) {
            GLFW.glfwSetCursor((long)CursorTypeUtil.WINDOW, (long)cursor.getId());
        }

        @Override
        public void resetCursor() {
            GLFW.glfwSetCursor((long)CursorTypeUtil.WINDOW, (long)0L);
        }

        @Override
        public void render(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        }
    }
}

