/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.impl;

import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import net.minecraft.Util;
import org.jetbrains.annotations.Nullable;

public final class CursorControllerImpl
implements CursorController {
    private final TransientCursor singleCycleCursor = new TransientCursor();
    private final TransientCursor singleCycleFallbackCursor = new TransientCursor();

    @Nullable
    public CursorType consumeTransientCursor() {
        return this.singleCycleCursor.consume();
    }

    @Nullable
    public CursorType consumeTransientFallbackCursor() {
        return this.singleCycleFallbackCursor.consume();
    }

    public void setSingleCycleCursor(CursorType cursorType) {
        this.singleCycleCursor.set(cursorType);
    }

    public void setSingleCycleFallbackCursor(CursorType cursorType) {
        this.singleCycleFallbackCursor.set(cursorType);
    }

    public void overrideCursor(CursorType cursorType, int index) {
        CursorManager.INSTANCE.overrideCurrentCursor(cursorType, index);
    }

    public void removeOverride(int index) {
        CursorManager.INSTANCE.removeOverride(index);
    }

    private static class TransientCursor {
        private static final long EXPIRE_MS = 100L;
        @Nullable
        private CursorType cursorType;
        private long timestamp = 0L;

        private TransientCursor() {
        }

        private boolean isValid() {
            return this.cursorType != null && Util.getMillis() - this.timestamp < 100L;
        }

        @Nullable
        private CursorType consume() {
            CursorType consumed = this.isValid() ? this.cursorType : null;
            this.cursorType = null;
            return consumed;
        }

        private void set(CursorType cursorType) {
            this.cursorType = cursorType;
            this.timestamp = Util.getMillis();
        }
    }
}

