/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.util;

import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class DrawUtil {
    private DrawUtil() {
    }

    public static void drawScrollableTextLeftAlign(GuiGraphics context, Font textRenderer, Component text, int startX, int startY, int endX, int endY, int color, boolean shadow) {
        int textWidth = textRenderer.width((FormattedText)text);
        int textY = (startY + endY - 9) / 2 + 1;
        int availableWidth = endX - startX;
        if (textWidth > availableWidth) {
            int overflowWidth = textWidth - availableWidth;
            double timeSeconds = (double)Util.getMillis() / 1000.0;
            double scrollDuration = Math.max((double)overflowWidth * 0.5, 3.0);
            double scrollFactor = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timeSeconds / scrollDuration)) / 2.0 + 0.5;
            double scrollOffset = Mth.lerp((double)scrollFactor, (double)0.0, (double)overflowWidth);
            context.enableScissor(startX, startY, endX, endY);
            context.drawString(textRenderer, text, startX - (int)scrollOffset, textY, color, shadow);
            context.disableScissor();
        } else {
            context.drawString(textRenderer, text, startX, textY, color, shadow);
        }
    }

    public static void drawScrollableTextLeftAlign(GuiGraphics context, Font textRenderer, Component text, int startX, int startY, int endX, int endY, int color) {
        DrawUtil.drawScrollableTextLeftAlign(context, textRenderer, text, startX, startY, endX, endY, color, true);
    }

    public static void drawCheckerboard(GuiGraphics guiGraphics, int x, int y, int width, int height, float cellSize, ResourceLocation checkerboard, int textureSize) {
        float drawWidth = (float)textureSize * cellSize;
        float drawHeight = (float)textureSize * cellSize;
        float clippedWidth = Math.min(drawWidth, (float)width);
        float clippedHeight = Math.min(drawHeight, (float)height);
        float uRatio = clippedWidth / drawWidth;
        float vRatio = clippedHeight / drawHeight;
        int uvWidth = Math.round((float)textureSize * uRatio);
        int uvHeight = Math.round((float)textureSize * vRatio);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, checkerboard, x, y, 0.0f, 0.0f, (int)clippedWidth, (int)clippedHeight, uvWidth, uvHeight, textureSize, textureSize);
    }
}

