/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.CursorResourceReloadListener;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.gui.screen.ConfigurationScreen;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod(value="minecraft_cursor")
public class MinecraftCursorForge {
    public static final String MOD_ID = "minecraft_cursor";

    public MinecraftCursorForge() {
        if (FMLEnvironment.dist.isClient()) {
            ConfigScreenHolder.register();
        }
    }

    private static class ConfigScreenHolder {
        private ConfigScreenHolder() {
        }

        private static void register() {
            MinecraftForge.registerConfigScreen(ConfigurationScreen::new);
        }
    }

    @Mod.EventBusSubscriber(modid="minecraft_cursor", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void afterClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                MinecraftCursor.afterClientTick(Minecraft.m_91087_());
            }
        }

        @SubscribeEvent
        public static void afterScreenRender(ScreenEvent.Render.Post event) {
            MinecraftCursor.afterCurrentScreenRender(Minecraft.m_91087_(), event.getScreen(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY());
        }
    }

    @Mod.EventBusSubscriber(modid="minecraft_cursor", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void addPackFinder(AddPackFindersEvent event) {
            if (event.getPackType() != PackType.CLIENT_RESOURCES) {
                return;
            }
            ResourceLocation location = new ResourceLocation(MinecraftCursorForge.MOD_ID, "resourcepacks/cursors_extended");
            String packId = "mod/" + String.valueOf(location);
            IModInfo modInfo = ModList.get().getModContainerById(MinecraftCursorForge.MOD_ID).map(ModContainer::getModInfo).orElseThrow();
            Path path = modInfo.getOwningFile().getFile().findResource(new String[]{location.m_135815_()});
            Pack pack = Pack.m_245429_((String)packId, (Component)Component.m_237113_((String)"Cursors Extended"), (boolean)false, id -> new PathPackResources(id, path, false), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }

        @SubscribeEvent
        public static void registerReloadListeners(RegisterClientReloadListenersEvent event) {
            MinecraftCursor.init();
            event.registerReloadListener((PreparableReloadListener)new CursorResourceReloadListener());
        }
    }
}

