/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.fishstiz.minecraftcursor.CursorResourceLoader;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.CursorTypeRegistrar;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import io.github.fishstiz.minecraftcursor.config.AnimationData;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationState;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.cursor.CursorRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CursorManager
implements CursorTypeRegistrar {
    public static final CursorManager INSTANCE = new CursorManager();
    private final Map<String, Cursor> cursors = new Object2ObjectLinkedOpenHashMap();
    private final TreeMap<Integer, String> overrides = new TreeMap();
    private final AnimationState animationState = new AnimationState();
    @NotNull
    private Cursor currentCursor = Cursor.createDummy();
    @NotNull
    private CursorRenderer renderer = MinecraftCursor.CONFIG.isVirtualMode() ? new CursorRenderer.Virtual() : new CursorRenderer.Native();

    private CursorManager() {
    }

    public void register(CursorType ... cursorTypes) {
        for (CursorType cursorType : cursorTypes) {
            this.register(cursorType);
        }
    }

    public CursorType register(String key) {
        return this.register(CursorType.of((String)key));
    }

    private CursorType register(CursorType cursorType) {
        String key = cursorType.getKey();
        if (key.isEmpty()) {
            throw new NullPointerException("Cursor type key cannot be empty.");
        }
        if (this.cursors.containsKey(key)) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Cursor type '{}' is already registered.", (Object)key);
            return cursorType;
        }
        this.cursors.put(key, new Cursor(cursorType, this::onLoad));
        return cursorType;
    }

    public Cursor loadCursor(Cursor cursor, NativeImage image, Config.Settings settings, @Nullable AnimationData animation) throws IOException {
        boolean animated;
        if (!this.cursors.containsKey(cursor.getTypeKey())) {
            throw new IllegalStateException("Attempting to load an unregistered cursor: " + cursor.getTypeKey());
        }
        boolean bl = animated = animation != null;
        if (animated != cursor instanceof AnimatedCursor) {
            cursor.destroy();
            cursor = animated ? new AnimatedCursor(cursor.getType(), this::onLoad) : new Cursor(cursor.getType(), this::onLoad);
            this.cursors.put(cursor.getTypeKey(), cursor);
        }
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            animatedCursor.loadImage(image, settings, animation);
        } else {
            cursor.loadImage(image, settings);
        }
        return cursor;
    }

    private void onLoad(Cursor cursor) {
        CursorType cursorType = cursor.getType();
        long id = cursor.getId();
        Minecraft.m_91087_().execute(() -> {
            Cursor appliedCursor = this.getAppliedCursor();
            if (appliedCursor.isLoaded() && appliedCursor.getType().isKey(cursorType) && appliedCursor.getId() == id) {
                this.reapplyCursor();
            }
        });
    }

    public void setCurrentCursor(@NotNull CursorType type) {
        Cursor cursor;
        Cursor override = this.getOverride();
        Cursor cursor2 = cursor = override != null ? override : this.cursors.get(type.getKey());
        if (cursor != null && cursor.isLazy() && MinecraftCursor.CONFIG.getOrCreateSettings(cursor).isEnabled()) {
            CursorResourceLoader.loadCursorTexture(cursor);
        }
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            if (cursor.getId() != 0L) {
                this.handleCursorAnimation(animatedCursor);
                return;
            }
        }
        if (cursor == null || !type.isDefault() && cursor.getId() == 0L || !cursor.isEnabled()) {
            cursor = this.getCursor(CursorType.DEFAULT);
        }
        this.updateCursor(cursor);
    }

    private void handleCursorAnimation(AnimatedCursor cursor) {
        Cursor currentFrameCursor;
        if (!this.getAppliedCursor().getType().isKey(cursor.getType())) {
            this.animationState.reset();
        }
        this.updateCursor((currentFrameCursor = cursor.nextFrame(this.animationState).cursor()).getId() != 0L ? currentFrameCursor : cursor);
    }

    private void updateCursor(Cursor cursor) {
        if (cursor == null || !MinecraftCursor.CONFIG.isAggressiveCursor() && cursor.getId() == this.currentCursor.getId() || ExternalCursorTracker.get().isCustom()) {
            return;
        }
        this.currentCursor = cursor;
        this.renderer.setCursor(this.currentCursor);
    }

    public void reapplyCursor() {
        if (!ExternalCursorTracker.get().isCustom()) {
            this.renderer.setCursor(this.getAppliedCursor());
        }
    }

    public void overrideCurrentCursor(CursorType type, int index) {
        Cursor cursor = this.getCursor(type);
        if (cursor != null && cursor.isEnabled()) {
            this.overrides.put(index, type.getKey());
        } else {
            this.overrides.remove(index);
        }
    }

    public void removeOverride(int index) {
        this.overrides.remove(index);
    }

    @Nullable
    public Cursor getOverride() {
        while (!this.overrides.isEmpty()) {
            Map.Entry<Integer, String> lastEntry = this.overrides.lastEntry();
            Cursor cursor = this.cursors.get(lastEntry.getValue());
            if (cursor == null || cursor.getId() == 0L) {
                this.overrides.remove(lastEntry.getKey());
                continue;
            }
            return cursor;
        }
        return null;
    }

    @NotNull
    public Cursor getAppliedCursor() {
        Cursor cursor;
        Cursor override = this.getOverride();
        Cursor cursor2 = cursor = override != null ? override : this.currentCursor;
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            return animatedCursor.getFrame(this.animationState.getCurrentFrame()).cursor();
        }
        return cursor;
    }

    public boolean isEnabled(@NotNull CursorType type) {
        return this.isEnabled(this.cursors.get(type.getKey()));
    }

    public boolean isEnabled(@Nullable Cursor cursor) {
        return cursor != null && (cursor.isLazy() && MinecraftCursor.CONFIG.getOrCreateSettings(cursor).isEnabled() || cursor.isEnabled());
    }

    @Nullable
    public Cursor getCursor(CursorType type) {
        return this.cursors.get(type.getKey());
    }

    @Nullable
    public Cursor getCursor(String type) {
        return this.cursors.get(type);
    }

    public long getCurrentId() {
        return this.getAppliedCursor().getId();
    }

    public Collection<Cursor> getCursors() {
        return this.cursors.values();
    }

    public boolean isAdaptive() {
        for (Cursor cursor : this.cursors.values()) {
            if (cursor.getType().isDefault() || !cursor.isLazy() && !cursor.isEnabled() || !MinecraftCursor.CONFIG.getOrCreateSettings(cursor).isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isVirtual() {
        return this.renderer instanceof CursorRenderer.Virtual;
    }

    public void toggleVirtual() {
        this.renderer.resetCursor();
        this.renderer = this.isVirtual() ? new CursorRenderer.Native() : new CursorRenderer.Virtual();
        this.reapplyCursor();
    }

    public void renderCursor(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderer.render(minecraft, guiGraphics, mouseX, mouseY);
    }
}

