/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor.resolver;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.Nullable;

public final class ElementWalker {
    private ElementWalker() {
    }

    public static <T> T walk(ContainerEventHandler parent, double mouseX, double mouseY, Processor<T> processor, Predicate<T> shouldReturn, T defaultValue) {
        if (ElementWalker.hovered((GuiEventListener)parent, mouseX, mouseY)) {
            for (GuiEventListener child : parent.m_6702_()) {
                ContainerEventHandler nestedParent;
                T result;
                if (child instanceof ContainerEventHandler && shouldReturn.test(result = ElementWalker.walk(nestedParent = (ContainerEventHandler)child, mouseX, mouseY, processor, shouldReturn, defaultValue))) {
                    return result;
                }
                if (!ElementWalker.hovered(child, mouseX, mouseY)) continue;
                return processor.processNode(child, mouseX, mouseY);
            }
        }
        return defaultValue;
    }

    @Nullable
    public static GuiEventListener findDeepest(ContainerEventHandler parent, double mouseX, double mouseY) {
        return ElementWalker.walk(parent, mouseX, mouseY, (child, x, y) -> child, Objects::nonNull, null);
    }

    @Nullable
    public static GuiEventListener findFirst(ContainerEventHandler parent, double mouseX, double mouseY) {
        if (ElementWalker.hovered((GuiEventListener)parent, mouseX, mouseY)) {
            for (GuiEventListener child : parent.m_6702_()) {
                if (!ElementWalker.hovered(child, mouseX, mouseY)) continue;
                return child;
            }
        }
        return null;
    }

    private static boolean hovered(GuiEventListener guiEventListener, double mouseX, double mouseY) {
        boolean bl;
        if (guiEventListener instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            bl = ElementWalker.widgetHovered(widget, mouseX, mouseY);
        } else {
            bl = guiEventListener.m_5953_(mouseX, mouseY);
        }
        return bl;
    }

    private static boolean widgetHovered(AbstractWidget widget, double mouseX, double mouseY) {
        return widget.f_93624_ && widget.m_274382_() && mouseX >= (double)widget.m_252754_() && mouseY >= (double)widget.m_252907_() && mouseX < (double)(widget.m_252754_() + widget.m_5711_()) && mouseY < (double)(widget.m_252907_() + widget.m_93694_());
    }

    @FunctionalInterface
    public static interface Processor<T> {
        public T processNode(GuiEventListener var1, double var2, double var4);
    }
}

