/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CatalogItem;
import io.github.fishstiz.minecraftcursor.gui.widget.AbstractListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ElementSlidingBackground;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.TabOrderedElement;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CatalogBrowserScreen
extends Screen {
    private static final Component SEARCH_TEXT = Component.m_237115_((String)"minecraft-cursor.options.search");
    private static final Tooltip CLEAR_SEARCH_INFO = Tooltip.m_257550_((Component)Component.m_237115_((String)"minecraft-cursor.options.search.clear"));
    private static final Tooltip REFRESH_INFO = Tooltip.m_257550_((Component)Component.m_237115_((String)"minecraft-cursor.options.refresh.info"));
    private static final ResourceLocation EXIT_SPRITE = MinecraftCursor.loc("textures/gui/sprites/icon/caret_right.png");
    private static final ResourceLocation CLEAR_SPRITE = MinecraftCursor.loc("textures/gui/sprites/icon/cross.png");
    private static final ResourceLocation CLEAR_INACTIVE_SPRITE = MinecraftCursor.loc("textures/gui/sprites/icon/cross_inactive.png");
    private static final ResourceLocation REFRESH_SPRITE = MinecraftCursor.loc("textures/gui/sprites/icon/arrow_clockwise.png");
    private final Screen previous;
    private final int headerHeight;
    private final int sidebarWidth;
    private final int maxContentWidth;
    private final int spacing;
    private final Map<CatalogItem, ItemContext> items = new LinkedHashMap<CatalogItem, ItemContext>();
    private EditBox searchField;
    private ButtonWidget clearButton;
    private ItemList catalog;
    private ButtonWidget doneButton;
    private ButtonWidget refreshButton;
    private ContentPanel contents;
    private String previousSearch = "";

    protected CatalogBrowserScreen(Component title, int headerHeight, int sidebarWidth, int maxContentWidth, int spacing, Screen previous) {
        super(title);
        this.headerHeight = headerHeight;
        this.sidebarWidth = sidebarWidth;
        this.maxContentWidth = maxContentWidth;
        this.spacing = spacing;
        this.previous = previous;
    }

    protected void initItems() {
    }

    protected void postInit() {
    }

    protected final void m_7856_() {
        this.doneButton = (ButtonWidget)this.m_142416_((GuiEventListener)new ButtonWidget(CommonComponents.f_130655_, this::m_7379_).withSize(20).withTooltip(CommonComponents.f_130655_).spriteOnly(EXIT_SPRITE));
        this.clearButton = new ButtonWidget(CommonComponents.f_237098_, this::clearSearch).withSize(20).withTooltip(CLEAR_SEARCH_INFO).spriteOnly(CLEAR_SPRITE, CLEAR_INACTIVE_SPRITE);
        this.clearButton.f_93623_ = false;
        this.searchField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.spacing, this.spacing, this.sidebarWidth - this.clearButton.m_5711_() - this.spacing, this.headerHeight, SEARCH_TEXT));
        this.searchField.m_257771_(SEARCH_TEXT);
        this.searchField.m_94151_(this::search);
        this.m_142416_((GuiEventListener)this.clearButton);
        this.catalog = (ItemList)this.m_142416_((GuiEventListener)new ItemList(this.f_96541_, this.f_96547_, this.sidebarWidth, this.spacing, this::onItemChange));
        this.refreshButton = (ButtonWidget)this.m_142416_((GuiEventListener)new ButtonWidget(CommonComponents.f_237098_, this::refreshItemsAndPanel).withSize(20).withTooltip(REFRESH_INFO).spriteOnly(REFRESH_SPRITE));
        this.initItems();
        this.refreshItems();
        this.m_267719_();
        this.postInit();
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.previous);
        }
    }

    public void m_7861_() {
        if (this.contents != null) {
            this.contents.removed();
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected final void m_267719_() {
        int contentsWidth = this.getContentWidth();
        int usableWidth = this.sidebarWidth + this.spacing + contentsWidth;
        int maxOffsetX = this.f_96543_ - usableWidth - this.spacing;
        int leftColumnX = Math.max(this.spacing, Math.min((this.f_96543_ - usableWidth) / 2, maxOffsetX));
        int rightColumnX = leftColumnX + this.sidebarWidth + this.spacing;
        if (this.doneButton != null && this.refreshButton != null) {
            this.doneButton.m_264152_(rightColumnX + contentsWidth - this.doneButton.m_5711_(), this.spacing);
            this.refreshButton.m_264152_(this.doneButton.m_252754_() - this.refreshButton.m_5711_() - this.spacing, this.spacing);
        }
        if (this.searchField != null && this.clearButton != null) {
            this.searchField.m_264152_(leftColumnX, this.spacing);
            this.clearButton.m_264152_(this.searchField.m_252754_() + this.searchField.m_5711_() + this.spacing, this.spacing);
        }
        if (this.catalog != null) {
            this.catalog.setHeight(this.f_96544_ - this.spacing * 2 - (this.headerHeight + this.spacing));
            this.catalog.m_264152_(leftColumnX, this.spacing + this.headerHeight + this.spacing);
            this.catalog.clampScrollAmount();
        }
        if (this.contents != null) {
            this.contents.setWidth(contentsWidth);
            this.contents.setHeight(this.f_96544_ - this.spacing * 2);
            this.contents.setPosition(rightColumnX, this.spacing);
            this.contents.repositionElements();
        }
    }

    protected int getContentWidth() {
        int totalWidth = this.f_96543_ - this.spacing * 2;
        return this.maxContentWidth <= 0 ? totalWidth - this.sidebarWidth - this.spacing : Math.min(this.maxContentWidth, totalWidth - this.sidebarWidth - this.spacing);
    }

    protected void selectItem(@Nullable CatalogItem item) {
        if (item != null) {
            this.catalog.select(item);
        } else {
            this.catalog.select((CatalogItem)null);
            if (this.contents != null) {
                this.m_169411_((GuiEventListener)this.contents);
                this.contents.removed();
                this.contents = null;
            }
        }
    }

    private void onItemChange(CatalogItem item) {
        ItemContext itemContext = this.items.get(item);
        if (itemContext == null) {
            throw new NullPointerException("CatalogItem " + item.id() + " context not found.");
        }
        ContentPanel contentPanel = itemContext.contents();
        if (contentPanel != this.contents) {
            if (this.contents != null) {
                this.m_169411_((GuiEventListener)this.contents);
                this.contents.removed();
            }
            this.contents = contentPanel;
            this.contents.changedItem(this.previousSearch, itemContext.category(), item);
            this.m_142416_((GuiEventListener)this.contents);
            this.contents.added(this.previousSearch);
        } else {
            this.contents.changedItem(this.previousSearch, itemContext.category(), item);
        }
        this.m_267719_();
    }

    protected CatalogItem addCategory(@NotNull CatalogItem category, boolean collapsible, boolean collapsed) {
        this.catalog.addCategory(Objects.requireNonNull(category), new CategoryContext(collapsible, collapsed));
        return category;
    }

    protected CatalogItem addCategory(@NotNull CatalogItem category) {
        return this.addCategory(category, true, false);
    }

    protected void addCategoryOnly(@NotNull CatalogItem category, @NotNull ContentPanel panel) {
        this.addCategory(category, false, true);
        this.items.put(category, new ItemContext(category, this.initPanel(panel)));
    }

    protected void addItem(@NotNull CatalogItem category, @NotNull CatalogItem item, @NotNull ContentPanel panel) {
        if (this.items.containsKey(Objects.requireNonNull(category))) {
            throw new IllegalStateException("Category " + category.id() + " is already an item.");
        }
        this.items.put(Objects.requireNonNull(item), new ItemContext(category, this.initPanel(panel)));
        this.catalog.addItem(category, item);
    }

    protected void updateItem(@NotNull CatalogItem item, @NotNull ContentPanel contentPanel) {
        ItemContext oldContext = this.items.get(item);
        if (oldContext == null) {
            throw new IllegalStateException("CatalogItem " + item.id() + " has not beed added.");
        }
        ItemContext context = Objects.requireNonNull(this.items.computeIfPresent(item, (i, ctx) -> new ItemContext(ctx.category(), this.initPanel(contentPanel))));
        this.items.replace(item, context);
        this.catalog.replaceItem(context.category(), item);
        if (this.contents != null && this.contents == oldContext.contents() && item.equals(this.contents.getItem())) {
            if (oldContext.contents() != context.contents()) {
                boolean isFocused = this.m_7222_() == this.contents;
                this.m_169411_((GuiEventListener)this.contents);
                this.contents.removed();
                this.contents = context.contents();
                if (isFocused) {
                    this.m_7522_((GuiEventListener)this.contents);
                }
                this.contents.changedItem(this.previousSearch, context.category(), item);
                this.m_142416_((GuiEventListener)this.contents);
                this.contents.added(this.previousSearch);
            } else {
                this.contents.changedItem(this.previousSearch, context.category(), item);
            }
            this.m_267719_();
        }
    }

    protected void addOrUpdateItem(@NotNull CatalogItem category, @NotNull CatalogItem item, @NotNull ContentPanel panel) {
        if (this.items.containsKey(item)) {
            this.updateItem(item, panel);
        } else {
            this.addItem(category, item, panel);
        }
    }

    protected void refreshItems() {
        this.catalog.refreshEntries();
    }

    protected void refreshItemsAndPanel() {
        this.refreshItems();
        if (this.contents != null) {
            this.contents.removed();
            this.contents.added();
        }
        this.m_267719_();
    }

    protected Button getRefreshButton() {
        return this.refreshButton;
    }

    private ContentPanel initPanel(ContentPanel panel) {
        panel.init(this.f_96541_, this.f_96547_, this, this.headerHeight, this.getContentWidth() - this.doneButton.m_5711_() - this.refreshButton.m_5711_() - this.spacing * 2, this.spacing);
        return panel;
    }

    protected void focusPath(GuiEventListener child) {
        ComponentPath componentpath = this.m_264435_();
        if (componentpath != null) {
            componentpath.m_264432_(false);
        }
        ComponentPath.m_264492_((GuiEventListener)child, (ContainerEventHandler[])new ContainerEventHandler[]{this}).m_264432_(true);
    }

    protected boolean autoFocusSearch() {
        return true;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (super.m_5534_(codePoint, modifiers)) {
            return true;
        }
        if (this.autoFocusSearch() && codePoint != ' ' && this.searchField != null && !this.searchField.m_93696_()) {
            this.focusPath((GuiEventListener)this.searchField);
            return this.searchField.m_5534_(codePoint, modifiers);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.autoFocusSearch() && keyCode == 259 && this.searchField != null && !this.searchField.m_93696_() && !this.searchField.m_94155_().isEmpty()) {
            this.focusPath((GuiEventListener)this.searchField);
            return this.searchField.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private void clearSearch() {
        if (this.searchField != null) {
            this.searchField.m_94144_("");
        }
    }

    private void search(String search) {
        if (this.clearButton != null) {
            boolean bl = this.clearButton.f_93623_ = !search.isEmpty();
        }
        if (Objects.equals(this.previousSearch, search)) {
            return;
        }
        this.previousSearch = search;
        if (search.isEmpty()) {
            this.catalog.filterItems(null);
            this.refreshItems();
            if (this.contents != null) {
                this.contents.searched(search, null);
            }
        } else {
            SearchResult result = this.performSearch(search.toLowerCase());
            this.catalog.filterItems(result.visibleItems());
            if (result.firstResult() != null) {
                this.selectItem(result.firstResult());
            }
            this.refreshItems();
            if (this.contents != null) {
                this.contents.searched(search, result.firstMatch());
            }
        }
    }

    private SearchResult performSearch(String lowercaseSearch) {
        HashMap<CatalogItem, Set<CatalogItem>> visibleItems = new HashMap<CatalogItem, Set<CatalogItem>>();
        CatalogItem firstResult = null;
        Component firstMatch = null;
        for (Map.Entry<CatalogItem, ItemContext> itemEntry : this.items.entrySet()) {
            ItemContext context;
            CatalogItem item = itemEntry.getKey();
            MatchResult matchResult = this.findMatch(item, context = itemEntry.getValue(), lowercaseSearch);
            if (!matchResult.hasMatch()) continue;
            if (firstResult == null) {
                firstResult = item;
                firstMatch = matchResult.matchedText();
            }
            visibleItems.computeIfAbsent(context.category(), k -> new HashSet()).add(item);
        }
        return new SearchResult(visibleItems, firstResult, firstMatch);
    }

    private MatchResult findMatch(CatalogItem item, ItemContext context, String lowercaseSearch) {
        Component matchedText = CatalogBrowserScreen.containsStringLowerCase(context.contents().indexed, lowercaseSearch);
        if (matchedText != null) {
            return new MatchResult(true, matchedText);
        }
        if (CatalogBrowserScreen.containsStringLowerCase(item.text(), lowercaseSearch)) {
            return new MatchResult(true, null);
        }
        if (CatalogBrowserScreen.containsStringLowerCase(context.category().text(), lowercaseSearch)) {
            return new MatchResult(true, null);
        }
        return new MatchResult(false, null);
    }

    private static boolean containsStringLowerCase(Component text, String string) {
        return text.m_6879_().getString().toLowerCase().contains(string);
    }

    @Nullable
    private static Component containsStringLowerCase(List<Component> texts, String string) {
        for (Component text : texts) {
            if (!CatalogBrowserScreen.containsStringLowerCase(text, string)) continue;
            return text;
        }
        return null;
    }

    private static class ItemList
    extends AbstractListWidget<AbstractItemEntry> {
        private static final int UNPADDED_HEIGHT = 8;
        private static final int BACKGROUND_COLOR = 0x7F000000;
        private static final int GRADIENT_HEIGHT = 4;
        private static final int PADDING_Y = 2;
        private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF);
        private final ElementSlidingBackground selectedBackground = new ElementSlidingBackground(0x33FFFFFF);
        private final ElementSlidingBackground focusedBackground = new ElementSlidingBackground(-1, true);
        private final Map<CatalogItem, CategoryContext> categories = new LinkedHashMap<CatalogItem, CategoryContext>();
        private final Map<CatalogItem, Set<CatalogItem>> visibleItems = new HashMap<CatalogItem, Set<CatalogItem>>();
        private final Consumer<CatalogItem> onSelect;
        private final Font font;
        private final int spacing;
        private boolean searching;
        @Nullable
        private CatalogItem selectedItem;

        private ItemList(Minecraft minecraft, Font font, int width, int spacing, Consumer<CatalogItem> onSelect) {
            super(minecraft, width, 0, 0, 8 + spacing * 2);
            this.onSelect = onSelect;
            this.font = font;
            this.spacing = spacing;
            this.m_93488_(false);
            this.m_93496_(false);
        }

        private void addCategory(CatalogItem category, CategoryContext context) {
            this.categories.put(category, context);
        }

        private void addItem(CatalogItem category, CatalogItem item) {
            CategoryContext context = this.categories.computeIfAbsent(category, c -> new CategoryContext());
            context.items().add(item);
        }

        private void replaceItem(@NotNull CatalogItem category, @NotNull CatalogItem item) {
            int index = this.indexOf(category, item);
            if (index == -1) {
                throw new IllegalStateException("CatalogItem " + item.id() + " has not beed added.");
            }
            this.categories.get(category).items().set(index, item);
        }

        private int indexOf(@NotNull CatalogItem category, @Nullable CatalogItem item) {
            CategoryContext context = this.categories.get(category);
            if (context != null) {
                List<CatalogItem> items = context.items();
                for (int i = 0; i < items.size(); ++i) {
                    if (!Objects.equals(items.get(i), item)) continue;
                    return i;
                }
            }
            return -1;
        }

        private void filterItems(@Nullable Map<CatalogItem, Set<CatalogItem>> visibleItems) {
            this.visibleItems.clear();
            boolean bl = this.searching = visibleItems != null;
            if (this.searching) {
                this.visibleItems.putAll(visibleItems);
            }
        }

        private void refreshEntries() {
            AbstractItemEntry focusedEntry = (AbstractItemEntry)this.m_7222_();
            AbstractItemEntry selectedEntry = (AbstractItemEntry)this.m_93511_();
            this.m_93516_();
            this.m_7522_(null);
            for (Map.Entry<CatalogItem, CategoryContext> categoryContexts : this.categories.entrySet()) {
                if (this.searching && !this.visibleItems.containsKey(categoryContexts.getKey())) continue;
                CategoryContext categoryContext = categoryContexts.getValue();
                CatalogItem categoryItem = categoryContexts.getKey().withText(text -> text.m_6881_().m_130938_(style -> style.m_131136_(Boolean.valueOf(true)))).withPrefix(CategoryEntry.applyCollapsibleSymbol(categoryContext));
                CategoryEntry categoryEntry = new CategoryEntry(this.font, categoryItem, categoryContext.collapsible(), this.spacing);
                this.m_7085_((AbstractSelectionList.Entry)categoryEntry);
                if (categoryContext.collapsed()) continue;
                Set<CatalogItem> items = this.visibleItems.get(categoryItem);
                for (CatalogItem item : categoryContexts.getValue().items()) {
                    if (this.searching && (items == null || !items.isEmpty() && !items.contains(item))) continue;
                    ItemEntry selectableEntry = new ItemEntry(this.font, item, this.spacing);
                    this.m_7085_((AbstractSelectionList.Entry)selectableEntry);
                }
            }
            this.m_7522_((GuiEventListener)focusedEntry);
            if (focusedEntry != selectedEntry) {
                this.setSelected(selectedEntry);
            }
            this.clampScrollAmount();
        }

        private void select(CatalogItem item, @Nullable AbstractItemEntry itemEntry) {
            if (this.selectedItem == null || !this.selectedItem.equals(item)) {
                this.selectedItem = item;
                this.m_7522_((GuiEventListener)itemEntry);
                if (itemEntry != null) {
                    this.m_93498_((AbstractSelectionList.Entry)itemEntry);
                }
                this.onSelect.accept(this.selectedItem);
            }
        }

        private void select(AbstractItemEntry itemEntry) {
            this.select(itemEntry.getItem(), itemEntry);
        }

        private void select(@Nullable CatalogItem item) {
            if (item != null) {
                this.select(item, this.getEntryFromItem(item));
            } else {
                this.selectedItem = null;
            }
        }

        private void toggleCategory(AbstractItemEntry itemEntry) {
            if (!(itemEntry instanceof CategoryEntry)) {
                throw new IllegalArgumentException("Entry is not an instance of CategoryEntry");
            }
            CategoryEntry categoryEntry = (CategoryEntry)itemEntry;
            CatalogItem category = categoryEntry.getItem();
            CategoryContext context = this.categories.computeIfPresent(category, (c, ctx) -> ctx.toggle());
            this.m_7522_((GuiEventListener)categoryEntry);
            this.refreshEntries();
            AbstractItemEntry focused = (AbstractItemEntry)this.m_7222_();
            if (focused != null) {
                focused.m_7522_((GuiEventListener)focused.button);
            }
            if (context != null && !context.collapsed() && this.indexOf(category, this.selectedItem) == -1) {
                this.select(context.items().get(0));
            }
        }

        @Nullable
        private AbstractItemEntry getEntryFromItem(@Nullable CatalogItem item) {
            if (item != null) {
                for (AbstractItemEntry entry : this.m_6702_()) {
                    if (!entry.getItem().equals(item)) continue;
                    return entry;
                }
            }
            return null;
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            this.selectedBackground.reset();
            this.focusedBackground.reset();
            return super.m_6050_(mouseX, mouseY, delta);
        }

        private void renderSlidingBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoveredBackground.render(guiGraphics, (LayoutElement)this.m_93412_(mouseX, mouseY), partialTick);
            this.selectedBackground.render(guiGraphics, this.getEntryFromItem(this.selectedItem), partialTick);
            this.focusedBackground.render(guiGraphics, (LayoutElement)this.m_7222_(), partialTick);
        }

        protected void m_7733_(@NotNull GuiGraphics guiGraphics) {
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.getRight(), this.getBottom(), 0x7F000000);
        }

        protected void renderListSeparators(@NotNull GuiGraphics guiGraphics) {
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.m_285978_(RenderType.m_286086_(), this.f_93393_, this.f_93390_ - 2, this.f_93392_, this.f_93390_ + 4 + 2, -16777216, 0, 0);
            guiGraphics.m_285978_(RenderType.m_286086_(), this.f_93393_, this.f_93391_ - 4 - 2, this.f_93392_, this.f_93391_ + 2, 0, -16777216, 0);
        }

        @Override
        public void m_239227_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        }

        public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderListSeparators(guiGraphics);
            this.m_280310_(guiGraphics);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.renderSlidingBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.m_239227_(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.m_280618_();
        }

        public void m_7522_(@Nullable GuiEventListener focused) {
            if (focused instanceof AbstractItemEntry) {
                AbstractItemEntry itemEntry = (AbstractItemEntry)focused;
                focused = this.getEntryFromItem(itemEntry.getItem());
            }
            super.m_7522_(focused);
        }

        public void setSelected(@Nullable AbstractItemEntry selected) {
            if (selected != null) {
                selected = this.getEntryFromItem(selected.getItem());
            }
            super.m_6987_((AbstractSelectionList.Entry)selected);
        }

        private abstract class AbstractItemEntry
        extends AbstractListWidget.Entry {
            protected final Font font;
            protected final CatalogItem item;
            protected final ItemButton button;
            protected final List<ItemButton> children;

            protected AbstractItemEntry(Font font, CatalogItem item, int spacing, Consumer<AbstractItemEntry> onClick) {
                super(ItemList.this);
                this.font = font;
                this.item = item;
                this.button = new ItemButton(this.item, this.font, spacing, itemButton -> onClick.accept(this));
                this.children = Collections.singletonList(this.button);
            }

            public void m_93692_(boolean focused) {
                super.m_93692_(focused);
                GuiEventListener focusedElement = this.m_7222_();
                if (focusedElement != null) {
                    focusedElement.m_93692_(focused);
                }
            }

            CatalogItem getItem() {
                return this.item;
            }

            public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                this.button.setSize(this.m_5711_(), this.m_93694_());
                this.button.m_264152_(this.m_252754_(), this.m_252907_());
                this.button.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }

            @NotNull
            public List<ItemButton> m_6702_() {
                return this.children;
            }

            @NotNull
            public List<ItemButton> m_142437_() {
                return this.children;
            }
        }

        private class CategoryEntry
        extends AbstractItemEntry {
            private static final Component COLLAPSED_SYMBOL = CategoryEntry.wrapSymbol("\u25b6");
            private static final Component COLLAPSIBLE_SYMBOL = CategoryEntry.wrapSymbol("\u25bc");
            private static final Component NON_COLLAPSIBLE_SYMBOL = CategoryEntry.wrapSymbol("\u25a0");
            private static final int SYMBOL_COLOR = -1;

            private CategoryEntry(Font font, CatalogItem item, boolean collapsible, int spacing) {
                super(font, item, spacing, collapsible ? ItemList.this::toggleCategory : ItemList.this::select);
            }

            private static Component wrapSymbol(String symbol) {
                return Component.m_237113_((String)symbol).m_130938_(style -> style.m_131136_(Boolean.valueOf(true)));
            }

            private static UnaryOperator<CatalogItem.Prefix> applyCollapsibleSymbol(CategoryContext context) {
                Component symbol = !context.collapsible() ? NON_COLLAPSIBLE_SYMBOL : (context.collapsed() ? COLLAPSED_SYMBOL : COLLAPSIBLE_SYMBOL);
                return prefix -> {
                    if (prefix != null) {
                        return prefix;
                    }
                    return (guiGraphics, font, item, bounds, spacing, mouseX, mouseY, partialTick) -> {
                        int x = bounds.m_252754_() + spacing;
                        int n = bounds.m_252907_();
                        int n2 = bounds.m_93694_();
                        Objects.requireNonNull(font);
                        int y = n + (n2 - 9) / 2;
                        int width = Math.max(font.m_92852_((FormattedText)NON_COLLAPSIBLE_SYMBOL), Math.max(font.m_92852_((FormattedText)COLLAPSED_SYMBOL), font.m_92852_((FormattedText)COLLAPSIBLE_SYMBOL)));
                        int endX = x + width;
                        Objects.requireNonNull(font);
                        int endY = y + 9;
                        DrawUtil.drawScrollableTextLeftAlign(guiGraphics, font, symbol, x, y, endX, endY, -1);
                        return width;
                    };
                };
            }
        }

        private class ItemEntry
        extends AbstractItemEntry {
            private ItemEntry(Font font, CatalogItem item, int spacing) {
                super(font, item, spacing, ItemList.this::select);
            }
        }
    }

    public static abstract class ContentPanel
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry {
        private final List<Component> indexed = new ArrayList<Component>();
        private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
        private final List<Renderable> renderables = new ArrayList<Renderable>();
        private final List<NarratableEntry> narratables = new ArrayList<NarratableEntry>();
        private int x;
        private int y;
        private int width;
        private int height;
        private NarratableEntry lastNarratable;
        private CatalogItem item;
        private CatalogItem category;
        private boolean initialized;
        private int spacing;
        private int headerHeight;
        private int headerWidth;
        private Minecraft minecraft;
        private Font font;
        private CatalogBrowserScreen catalog;
        @NotNull
        private String search = "";

        protected void added() {
        }

        protected void removed() {
        }

        protected void changed(@NotNull CatalogItem category, @NotNull CatalogItem item) {
        }

        protected void searched(@NotNull String search, @Nullable Component matched) {
        }

        protected void repositionElements() {
        }

        protected abstract void init();

        private void init(Minecraft minecraft, Font font, CatalogBrowserScreen catalog, int headerHeight, int headerWidth, int spacing) {
            if (!this.initialized) {
                this.initialized = true;
                this.minecraft = minecraft;
                this.font = font;
                this.catalog = catalog;
                this.spacing = spacing;
                this.headerHeight = headerHeight;
                this.headerWidth = headerWidth;
                this.init();
            }
        }

        private void added(@NotNull String search) {
            this.search = search;
            this.added();
        }

        private void changedItem(@NotNull String search, @NotNull CatalogItem category, @NotNull CatalogItem item) {
            this.category = Objects.requireNonNull(category);
            this.item = Objects.requireNonNull(item);
            this.search = search;
            this.changed(this.category, this.item);
        }

        protected void clearWidgets() {
            this.indexed.clear();
            this.children.clear();
            this.renderables.clear();
            this.narratables.clear();
        }

        protected Component index(Component text) {
            this.indexed.add(text);
            return text;
        }

        protected <T extends Renderable & GuiEventListener> void addRenderableWidget(T widget) {
            this.children.add(widget);
            this.narratables.add((NarratableEntry)widget);
            this.renderables.add(widget);
        }

        protected void addRenderableIndexedWidget(AbstractWidget widget) {
            this.addRenderableWidget(widget);
            this.indexed.add(widget.m_6035_());
        }

        protected final void changeItem(CatalogItem item) {
            this.catalog.selectItem(item);
        }

        protected CatalogBrowserScreen getScreen() {
            return this.catalog;
        }

        protected Minecraft getMinecraft() {
            return this.minecraft;
        }

        protected Font getFont() {
            return this.font;
        }

        public CatalogItem getItem() {
            return this.item;
        }

        public CatalogItem getCategory() {
            return this.category;
        }

        @NotNull
        public String getSearch() {
            return this.search;
        }

        public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            for (Renderable renderable : this.renderables) {
                renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.getWidth()) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.getHeight());
        }

        @NotNull
        public List<GuiEventListener> m_6702_() {
            return this.children;
        }

        private void setPosition(int x, int y) {
            this.setX(x);
            this.setY(y);
        }

        private void setX(int x) {
            this.x = x;
        }

        private void setY(int y) {
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        private void setWidth(int width) {
            this.width = width;
        }

        public int getWidth() {
            return this.width;
        }

        private void setHeight(int height) {
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }

        public int getRight() {
            return this.getX() + this.getWidth();
        }

        public int getBottom() {
            return this.getY() + this.getHeight();
        }

        public int getSpacing() {
            return this.spacing;
        }

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public int getHeaderWidth() {
            return this.headerWidth;
        }

        @NotNull
        public final NarratableEntry.NarrationPriority m_142684_() {
            return this.m_93696_() ? NarratableEntry.NarrationPriority.FOCUSED : NarratableEntry.NarrationPriority.NONE;
        }

        public final void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
            List<NarratableEntry> sortedNarratables = this.narratables.stream().filter(NarratableEntry::m_142518_).sorted(Comparator.comparingInt(TabOrderedElement::m_267579_)).toList();
            Screen.NarratableSearchResult narratableSearchResult = Screen.m_169400_(sortedNarratables, (NarratableEntry)this.lastNarratable);
            if (narratableSearchResult != null) {
                if (narratableSearchResult.f_169422_.m_169123_()) {
                    this.lastNarratable = narratableSearchResult.f_169420_;
                }
                if (sortedNarratables.size() > 1 && narratableSearchResult.f_169422_ == NarratableEntry.NarrationPriority.FOCUSED) {
                    narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
                }
                narratableSearchResult.f_169420_.m_142291_(narrationElementOutput.m_142047_());
            }
        }
    }

    private record ItemContext(@NotNull CatalogItem category, @NotNull ContentPanel contents) {
        private ItemContext(@NotNull CatalogItem category, @NotNull ContentPanel contents) {
            Objects.requireNonNull(category);
            Objects.requireNonNull(contents);
        }
    }

    private record CategoryContext(boolean collapsible, boolean collapsed, @NotNull List<CatalogItem> items) {
        private CategoryContext(boolean collapsible, boolean collapsed, @NotNull List<CatalogItem> items) {
            Objects.requireNonNull(items);
        }

        public CategoryContext(boolean collapsible, boolean collapsed) {
            this(collapsible, collapsed, new ArrayList<CatalogItem>());
        }

        public CategoryContext() {
            this(true, false, new ArrayList<CatalogItem>());
        }

        private CategoryContext toggle() {
            if (!this.collapsible) {
                throw new IllegalStateException("Cannot collapse non-collapsible category");
            }
            return new CategoryContext(true, !this.collapsed, this.items);
        }
    }

    private record SearchResult(Map<CatalogItem, Set<CatalogItem>> visibleItems, @Nullable CatalogItem firstResult, @Nullable Component firstMatch) {
    }

    private record MatchResult(boolean hasMatch, Component matchedText) {
    }

    private static class ItemButton
    extends AbstractButton {
        private static final int TEXT_COLOR = -1;
        private final Consumer<ItemButton> onClick;
        private final CatalogItem item;
        private final Font font;
        private final int spacing;

        public ItemButton(CatalogItem item, Font font, int spacing, Consumer<ItemButton> onClick) {
            super(0, 0, 0, 0, item.text());
            this.font = font;
            this.item = item;
            this.spacing = spacing;
            this.onClick = Objects.requireNonNull(onClick);
        }

        public void setSize(int width, int height) {
            this.m_93674_(width);
            this.f_93619_ = height;
        }

        public void m_5691_() {
            this.onClick.accept(this);
        }

        protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int prefixWidth;
            int n = prefixWidth = this.item.prefix() != null ? this.item.prefix().render(guiGraphics, this.font, this.item, (LayoutElement)this, this.spacing, mouseX, mouseY, partialTick) : 0;
            if (prefixWidth > 0) {
                prefixWidth += this.spacing;
            }
            int startX = this.m_252754_() + this.spacing + prefixWidth;
            int n2 = this.m_252907_();
            int n3 = this.m_93694_();
            Objects.requireNonNull(this.font);
            int startY = n2 + (n3 - 9) / 2;
            int endX = this.m_252754_() + this.m_5711_() - this.spacing;
            Objects.requireNonNull(this.font);
            int endY = startY + 9;
            DrawUtil.drawScrollableTextLeftAlign(guiGraphics, this.font, this.m_6035_(), startX, startY, endX, endY, -1);
        }

        protected void m_168797_(@NotNull NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, this.m_6035_());
        }
    }
}

