/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorResourceLoader;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.gui.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.screen.CatalogBrowserScreen;
import io.github.fishstiz.minecraftcursor.gui.screen.CatalogItem;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.AdaptiveOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.CompatibilityOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.CursorOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.DebugOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.GlobalOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.widget.ContainerEventHandlerPatch;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigurationScreen
extends CatalogBrowserScreen
implements ContainerEventHandlerPatch {
    private static final Component GLOBAL_TEXT = Component.m_237115_((String)"minecraft-cursor.options.global");
    private static final Component ADAPTIVE_TEXT = Component.m_237115_((String)"minecraft-cursor.options.adapt");
    private static final Component COMPAT_TEXT = Component.m_237115_((String)"minecraft-cursor.options.compat");
    private static final Component CURSORS_TEXT = Component.m_237115_((String)"minecraft-cursor.options.cursor-types");
    private static final Component DEBUG_TEXT = Component.m_237115_((String)"minecraft-cursor.options.debug");
    private static final int SPACING = 8;
    private static final int HEADER_HEIGHT = 20;
    private static final int SIDEBAR_WIDTH = 140;
    private static final int MAX_CONTENT_WIDTH = 264;
    private static final int LIST_CURSOR_SIZE = 16;
    private static final int BUSY_OVERRIDE = -10;
    private static final CatalogItem GLOBAL_CATEGORY = new CatalogItem("global", GLOBAL_TEXT);
    private static final CatalogItem CURSORS_CATEGORY = new CatalogItem("cursors", CURSORS_TEXT);
    private final CursorAnimationHelper animationHelper = new CursorAnimationHelper();
    private CatalogItem defaultItem;
    private CompletableFuture<Void> refreshFuture;

    public ConfigurationScreen(Screen previous) {
        super((Component)Component.m_237115_((String)"minecraft-cursor.options"), 20, 140, 264, 8, previous);
    }

    public void m_274333_() {
        for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
            if (!cursor.isLazy()) continue;
            CursorResourceLoader.loadCursorTexture(cursor);
        }
    }

    @Override
    public void m_7379_() {
        if (this.refreshFuture != null) {
            this.refreshFuture.join();
        }
        CursorController.getInstance().removeOverride(-10);
        MinecraftCursor.CONFIG.save();
        super.m_7379_();
    }

    @Override
    protected void initItems() {
        this.addGlobalItems();
        this.addAdaptiveItems();
        this.addCursorItems();
        this.addCompatibilityItems();
        this.addDebugItems();
    }

    @Override
    protected void postInit() {
        this.selectItem(this.defaultItem);
    }

    @Override
    protected void refreshItemsAndPanel() {
        if (this.refreshFuture != null && !this.refreshFuture.isDone()) {
            return;
        }
        this.getRefreshButton().f_93623_ = false;
        CursorController.getInstance().overrideCursor(CursorType.BUSY, -10);
        this.refreshFuture = CompletableFuture.runAsync(CursorResourceLoader::reload, Util.m_183991_()).thenRunAsync(() -> {
            this.addCursorItems();
            super.refreshItemsAndPanel();
            this.getRefreshButton().f_93623_ = true;
            CursorController.getInstance().removeOverride(-10);
        }, (Executor)this.f_96541_);
    }

    private void addGlobalItems() {
        this.addCategoryOnly(GLOBAL_CATEGORY, new GlobalOptionsPanel(this::refreshCursors));
    }

    private void addAdaptiveItems() {
        this.addCategoryOnly(new CatalogItem("adaptive", ADAPTIVE_TEXT), new AdaptiveOptionsPanel(ADAPTIVE_TEXT, this.animationHelper, this::refreshCursors));
    }

    private void addCompatibilityItems() {
        this.addCategoryOnly(new CatalogItem("compatibility", COMPAT_TEXT), new CompatibilityOptionsPanel(COMPAT_TEXT));
    }

    private void addCursorItems() {
        for (CatalogItem cursorItem : this.createCursorItems()) {
            if (CursorType.DEFAULT.getKey().equals(cursorItem.id())) {
                this.defaultItem = cursorItem;
            }
            this.addOrUpdateItem(CURSORS_CATEGORY, cursorItem, new CursorOptionsPanel(this.animationHelper, this::refreshCursors, GLOBAL_CATEGORY, Objects.requireNonNull(CursorManager.INSTANCE.getCursor(cursorItem.id()))));
        }
    }

    private void addDebugItems() {
        this.addCategoryOnly(new CatalogItem("debug", DEBUG_TEXT), new DebugOptionsPanel(DEBUG_TEXT));
    }

    private int renderListCursor(GuiGraphics guiGraphics, Font font, CatalogItem item, LayoutElement bounds, int spacing, int mouseX, int mouseY, float partialTick) {
        Cursor cursor = CursorManager.INSTANCE.getCursor(item.id());
        if (cursor != null && cursor.isLoaded()) {
            int prefixX = bounds.m_252754_() + spacing;
            int prefixY = bounds.m_252907_() + (bounds.m_93694_() - 16) / 2;
            this.animationHelper.drawSprite(guiGraphics, cursor, prefixX, prefixY, 16);
        }
        return 16;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return ContainerEventHandlerPatch.super.m_6348_(mouseX, mouseY, button);
    }

    private void refreshCursors() {
        this.addCursorItems();
        this.refreshItems();
    }

    private List<CatalogItem> createCursorItems() {
        return CursorManager.INSTANCE.getCursors().stream().map(cursor -> new CatalogItem(cursor.getTypeKey(), (Component)cursor.getText().m_6881_().m_130940_(ConfigurationScreen.getCursorFormat(cursor)), this::renderListCursor)).toList();
    }

    private static ChatFormatting getCursorFormat(@NotNull Cursor cursor) {
        if (cursor.isEnabled()) {
            return ChatFormatting.WHITE;
        }
        if (cursor.isLoaded()) {
            return ChatFormatting.GRAY;
        }
        return ChatFormatting.DARK_GRAY;
    }
}

