/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorWidget;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorPreviewWidget
extends CursorWidget {
    private static final ResourceLocation BACKGROUND_128 = MinecraftCursor.loc("textures/gui/background_dark_128.png");
    private static final Component PREVIEW_TEXT = Component.m_237115_((String)"minecraft-cursor.options.preview");
    private static final int PREVIEW_TEXT_OFFSET = 4;
    private static final int PREVIEW_TEXT_COLOR = Integer.MAX_VALUE;
    private static final int RULER_COLOR = -16711936;
    private static final int BACKGROUND_DISABLED = 0x7F000000;
    private static final int DEFAULT_BUTTON_SIZE = 20;
    @Nullable
    private final Button button;
    private final Font font;

    public CursorPreviewWidget(@NotNull Cursor cursor, @NotNull Font font, @Nullable Button button) {
        super(CommonComponents.f_237098_, cursor, BACKGROUND_128);
        this.f_93623_ = false;
        this.font = font;
        this.button = button;
    }

    public CursorPreviewWidget(@NotNull Cursor cursor, @NotNull Font font) {
        this(cursor, font, Button.m_253074_((Component)CommonComponents.f_237098_, b -> b.m_93692_(false)).m_253046_(20, 20).m_253136_());
    }

    @Override
    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Cursor cursor = this.getCursor();
        if (cursor.isLoaded()) {
            this.renderBackground(guiGraphics);
            if (cursor.isEnabled()) {
                this.renderPreviewText(guiGraphics);
                this.renderTestButton(guiGraphics, mouseX, mouseY, partialTick);
                this.renderRuler(guiGraphics, mouseX, mouseY);
            }
        }
        if (!cursor.isEnabled()) {
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.getRight(), this.getBottom(), 0x7F000000);
        }
        this.renderBorder(guiGraphics);
    }

    protected void renderPreviewText(@NotNull GuiGraphics guiGraphics) {
        int width = this.font.m_92852_((FormattedText)PREVIEW_TEXT);
        int endX = this.getRight() - 4;
        int endY = this.getBottom() - 4;
        int startX = endX - width;
        Objects.requireNonNull(this.font);
        int startY = endY - 9;
        DrawUtil.drawScrollableTextLeftAlign(guiGraphics, this.font, PREVIEW_TEXT, startX, startY, endX, endY, Integer.MAX_VALUE, false);
        guiGraphics.m_280262_();
    }

    protected void renderTestButton(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.button != null) {
            int buttonX = this.m_252754_() + (this.m_5711_() / 2 - this.button.m_5711_() / 2);
            int buttonY = this.m_252907_() + (this.m_93694_() / 2 - this.button.m_93694_() / 2);
            this.button.m_264152_(buttonX, buttonY);
            this.button.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected void renderRuler(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.m_5953_(mouseX, mouseY)) {
            guiGraphics.m_280656_(this.m_252754_(), this.getRight() - 1, mouseY, -16711936);
            guiGraphics.m_280315_(mouseX, this.m_252907_(), this.getBottom(), -16711936);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.button != null && this.button.m_5953_(mouseX, mouseY)) {
            this.button.m_6375_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() && mouseX < (double)this.getRight() && mouseY < (double)this.getBottom();
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        return this.getCursor().getType();
    }
}

