/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class CursorWidget
extends AbstractWidget
implements CursorProvider {
    public static final int DEFAULT_HEIGHT = 32;
    public static final int DEFAULT_WIDTH = 32;
    private static final int BACKGROUND_SIZE = 128;
    private static final int BORDER_COLOR = -16777216;
    private static final int FOCUSED_BORDER_COLOR = -1;
    private final ResourceLocation background128;
    private final Cursor cursor;

    protected CursorWidget(int x, int y, int width, int height, @NotNull Component message, @NotNull Cursor cursor, @NotNull ResourceLocation background128) {
        super(x, y, width, height, message);
        this.cursor = cursor;
        this.background128 = background128;
    }

    protected CursorWidget(@NotNull Component message, @NotNull Cursor cursor, @NotNull ResourceLocation background128) {
        this(0, 0, 32, 32, message, cursor, background128);
    }

    protected void renderCursor(@NotNull GuiGraphics guiGraphics, @NotNull Cursor cursor) {
    }

    protected abstract void renderRuler(@NotNull GuiGraphics var1, int var2, int var3);

    protected void renderBackground(@NotNull GuiGraphics guiGraphics) {
        DrawUtil.drawCheckerboard(guiGraphics, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), this.getCellSize(), this.background128, 128);
    }

    protected void renderBorder(@NotNull GuiGraphics guiGraphics) {
        int color = this.m_93696_() && this.f_93623_ ? -1 : -16777216;
        guiGraphics.m_280637_(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), color);
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.cursor.isLoaded()) {
            this.renderBackground(guiGraphics);
            this.renderCursor(guiGraphics, this.cursor);
            this.renderRuler(guiGraphics, mouseX, mouseY);
        }
        this.renderBorder(guiGraphics);
    }

    @NotNull
    protected Cursor getCursor() {
        return this.cursor;
    }

    protected float getCellSize() {
        Cursor currentCursor = this.getCursor();
        return currentCursor.isLoaded() ? (float)this.m_5711_() / (float)this.getCursor().getTextureWidth() : 0.0f;
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public int getRight() {
        return this.m_252754_() + this.m_5711_();
    }

    public int getBottom() {
        return this.m_252907_() + this.m_93694_();
    }

    protected void m_168797_(@NotNull NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }
}

