/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementSlidingBackground {
    private static final float ANIMATION_SPEED = 25.0f;
    private final boolean outlineOnly;
    private final int color;
    private float lastY = 0.0f;
    private long lastFrameTime = Util.m_137569_();

    public ElementSlidingBackground(int color, boolean outlineOnly) {
        this.color = color;
        this.outlineOnly = outlineOnly;
    }

    public ElementSlidingBackground(int color) {
        this(color, false);
    }

    public void reset() {
        this.lastY = 0.0f;
        this.lastFrameTime = Util.m_137569_();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int x, int y, int width, int height, float partialTick) {
        long now = Util.m_137569_();
        float deltaTime = (float)(now - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = now;
        float f = this.lastY = this.lastY == 0.0f ? (float)y : this.lastY;
        if (Math.abs(this.lastY - (float)y) < 0.5f) {
            this.lastY = y;
        } else {
            float alpha = 1.0f - (float)Math.exp(-25.0f * deltaTime);
            this.lastY = Mth.m_14179_((float)alpha, (float)this.lastY, (float)y);
        }
        int right = x + width;
        int bottom = (int)this.lastY + height;
        if (this.outlineOnly) {
            guiGraphics.m_280637_(x, (int)this.lastY, width, height, this.color);
        } else {
            guiGraphics.m_280509_(x, (int)this.lastY, right, bottom, this.color);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, @Nullable LayoutElement element, float partialTick) {
        if (element == null) {
            this.reset();
            return;
        }
        this.render(guiGraphics, element.m_252754_(), element.m_252907_(), element.m_5711_(), element.m_93694_(), partialTick);
    }
}

