/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.gui.widget.AbstractListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ElementSlidingBackground;
import io.github.fishstiz.minecraftcursor.gui.widget.SliderWidget;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsListWidget
extends AbstractListWidget<AbstractEntry> {
    private static final int BACKGROUND_PADDING_Y = 2;
    private static final int SEARCH_HIGHLIGHT_COLOR = 1728042752;
    private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF);
    private final Font font;
    @NotNull
    private String search = "";

    public OptionsListWidget(Minecraft minecraft, Font font, int itemHeight, int spacing) {
        super(minecraft, 0, 0, 0, itemHeight, spacing);
        this.font = font;
        this.m_93488_(false);
        this.m_93496_(false);
    }

    public OptionsListWidget(Minecraft minecraft, Font font, int spacing) {
        this(minecraft, font, 20, spacing);
    }

    public void addButton(ButtonWidget button) {
        this.m_7085_((AbstractSelectionList.Entry)new ButtonEntry(button));
    }

    public void addToggle(boolean value, @NotNull Consumer<Boolean> onToggle, @NotNull Component label, @Nullable Tooltip tooltip, boolean active) {
        this.m_7085_((AbstractSelectionList.Entry)new ToggleEntry(value, onToggle, label, null, tooltip, active));
    }

    public void addToggle(boolean value, @NotNull Consumer<Boolean> onToggle, @NotNull Component label, @Nullable Prefix prefix, @Nullable Tooltip tooltip, boolean active) {
        this.m_7085_((AbstractSelectionList.Entry)new ToggleEntry(value, onToggle, label, prefix, tooltip, active));
    }

    public void addToggleableSlider(@NotNull SliderWidget slider, boolean value, @NotNull Consumer<Boolean> onToggle, @Nullable Tooltip tooltip) {
        this.m_7085_((AbstractSelectionList.Entry)new ToggleableSliderEntry(slider, value, onToggle, tooltip, true));
    }

    public void search(@NotNull String search) {
        this.search = search.toLowerCase();
        if (!this.search.isEmpty()) {
            for (AbstractEntry entry : this.m_6702_()) {
                if (!entry.indexedLabel.contains(this.search)) continue;
                this.m_93498_((AbstractSelectionList.Entry)entry);
                break;
            }
        }
    }

    private int computeBackgroundX(AbstractEntry entry) {
        return entry.m_252754_() - this.rowGap;
    }

    private int computeBackgroundY(AbstractEntry entry) {
        return entry.m_252907_() - 2;
    }

    private int computeBackgroundWidth(AbstractEntry entry) {
        return entry.m_5711_() + this.rowGap + (this.scrollbarVisible() ? 6 : 2);
    }

    private int computeBackgroundHeight(AbstractEntry entry) {
        return entry.m_93694_() + 4;
    }

    protected void renderSearchBackground(@NotNull GuiGraphics guiGraphics) {
        if (!this.search.isEmpty()) {
            for (AbstractEntry entry : this.m_6702_()) {
                if (!entry.indexedLabel.contains(this.search)) continue;
                int bgX = this.computeBackgroundX(entry);
                int bgY = this.computeBackgroundY(entry);
                int bgWidth = this.computeBackgroundWidth(entry);
                int bgHeight = this.computeBackgroundHeight(entry);
                guiGraphics.m_280509_(bgX, bgY, bgX + bgWidth, bgY + bgHeight, 1728042752);
            }
        }
    }

    protected void renderEntryBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int minX = this.m_252754_() - this.rowGap;
        int minY = this.m_252907_() - 2;
        int maxX = this.getRight() + 6;
        int maxY = this.getBottom() + 2;
        guiGraphics.m_280588_(minX, minY, maxX, maxY);
        this.renderSearchBackground(guiGraphics);
        AbstractEntry entry = (AbstractEntry)this.m_93412_(mouseX, mouseY);
        if (entry == null) {
            this.hoveredBackground.reset();
        } else {
            int x = this.computeBackgroundX(entry);
            int y = this.computeBackgroundY(entry);
            int width = this.computeBackgroundWidth(entry);
            int height = this.computeBackgroundHeight(entry);
            this.hoveredBackground.render(guiGraphics, x, y, width, height, partialTick);
        }
        guiGraphics.m_280618_();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderEntryBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private class ButtonEntry
    extends AbstractEntry {
        private final ButtonWidget widget;

        private ButtonEntry(ButtonWidget widget) {
            super(widget.m_6035_());
            this.widget = this.addChild(widget);
        }

        @Override
        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.widget.m_93674_(width);
            this.widget.setHeight(height - OptionsListWidget.this.rowGap);
            this.widget.m_264152_(left, top);
            super.m_6311_(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
        }
    }

    private class ToggleEntry
    extends AbstractEntry {
        protected static final int BUTTON_WIDTH = 40;
        private static final int LABEL_COLOR = -1;
        private static final int DISABLED_COLOR = -5592406;
        private final ButtonWidget button;
        private final Consumer<Boolean> onToggle;
        @Nullable
        private final Prefix prefix;
        protected boolean value;

        private ToggleEntry(@NotNull boolean value, @NotNull Consumer<Boolean> onToggle, @Nullable Component label, @Nullable Prefix prefix, Tooltip tooltip, boolean active) {
            super(label);
            this.value = value;
            this.onToggle = onToggle;
            this.button = new ButtonWidget(this.getRight() - 40, this.m_252907_(), 40, 20, value ? CommonComponents.f_130653_ : CommonComponents.f_130654_, this::onPress);
            this.button.m_257544_(tooltip);
            this.button.f_93623_ = active;
            this.prefix = prefix;
            this.addChild(this.button);
        }

        protected void onPress(Button button) {
            this.value = !this.value;
            this.button.m_93666_(this.value ? CommonComponents.f_130653_ : CommonComponents.f_130654_);
            this.onToggle.accept(this.value);
        }

        protected void renderLabel(@NotNull GuiGraphics guiGraphics) {
            int marginX = 0;
            if (this.prefix != null && (marginX = this.prefix.render(guiGraphics, OptionsListWidget.this.font, this.m_252754_(), this.m_252907_(), this.m_93694_())) > 0) {
                marginX += OptionsListWidget.this.rowGap;
            }
            int startX = this.m_252754_() + marginX;
            int startY = this.m_252907_();
            int endX = this.button.m_252754_() - OptionsListWidget.this.rowGap;
            int endY = this.getBottom();
            int color = this.value ? -1 : -5592406;
            DrawUtil.drawScrollableTextLeftAlign(guiGraphics, OptionsListWidget.this.font, this.label, startX, startY, endX, endY, color);
        }

        @Override
        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.button.m_264152_(this.getRight() - this.button.m_5711_(), top);
            this.renderLabel(guiGraphics);
            super.m_6311_(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
        }
    }

    @FunctionalInterface
    public static interface Prefix {
        public int render(@NotNull GuiGraphics var1, Font var2, int var3, int var4, int var5);
    }

    private class ToggleableSliderEntry
    extends ToggleEntry {
        private final SliderWidget slider;

        private ToggleableSliderEntry(SliderWidget slider, @NotNull boolean value, @Nullable Consumer<Boolean> onToggle, Tooltip tooltip, boolean active) {
            super(value, onToggle, slider.m_6035_(), null, tooltip, active);
            this.slider = slider;
            this.slider.f_93623_ = value;
            this.addChild(this.slider);
        }

        @Override
        protected void onPress(Button button) {
            super.onPress(button);
            this.slider.f_93623_ = this.value;
        }

        @Override
        protected void renderLabel(@NotNull GuiGraphics guiGraphics) {
        }

        @Override
        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.m_6311_(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
            this.slider.m_93674_(width - 40 - OptionsListWidget.this.rowGap);
            this.slider.m_264152_(left, top);
            this.slider.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected abstract class AbstractEntry
    extends AbstractListWidget.Entry {
        protected final Component label;
        private final String indexedLabel;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();

        protected AbstractEntry(Component label) {
            this.label = label;
            this.indexedLabel = label.getString().toLowerCase();
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            for (AbstractWidget child : this.children) {
                child.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        protected <T extends AbstractWidget> T addChild(T child) {
            this.children.add(child);
            return child;
        }

        @NotNull
        public List<AbstractWidget> m_6702_() {
            return this.children;
        }

        @NotNull
        public List<AbstractWidget> m_142437_() {
            return this.children;
        }
    }
}

