/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.util;

import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class DrawUtil {
    private DrawUtil() {
    }

    public static void drawScrollableTextLeftAlign(GuiGraphics context, Font textRenderer, Component text, int startX, int startY, int endX, int endY, int color, boolean shadow) {
        int textWidth = textRenderer.m_92852_((FormattedText)text);
        int textY = (startY + endY - 9) / 2 + 1;
        int availableWidth = endX - startX;
        if (textWidth > availableWidth) {
            int overflowWidth = textWidth - availableWidth;
            double timeSeconds = (double)Util.m_137550_() / 1000.0;
            double scrollDuration = Math.max((double)overflowWidth * 0.5, 3.0);
            double scrollFactor = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timeSeconds / scrollDuration)) / 2.0 + 0.5;
            double scrollOffset = Mth.m_14139_((double)scrollFactor, (double)0.0, (double)overflowWidth);
            context.m_280588_(startX, startY, endX, endY);
            context.m_280614_(textRenderer, text, startX - (int)scrollOffset, textY, color, shadow);
            context.m_280618_();
        } else {
            context.m_280614_(textRenderer, text, startX, textY, color, shadow);
        }
    }

    public static void drawScrollableTextLeftAlign(GuiGraphics context, Font textRenderer, Component text, int startX, int startY, int endX, int endY, int color) {
        DrawUtil.drawScrollableTextLeftAlign(context, textRenderer, text, startX, startY, endX, endY, color, true);
    }

    public static void drawCheckerboard(GuiGraphics guiGraphics, int x, int y, int width, int height, float cellSize, ResourceLocation checkerboard, int textureSize) {
        float drawWidth = (float)textureSize * cellSize;
        float drawHeight = (float)textureSize * cellSize;
        float clippedWidth = Math.min(drawWidth, (float)width);
        float clippedHeight = Math.min(drawHeight, (float)height);
        float uRatio = clippedWidth / drawWidth;
        float vRatio = clippedHeight / drawHeight;
        int uvWidth = Math.round((float)textureSize * uRatio);
        int uvHeight = Math.round((float)textureSize * vRatio);
        guiGraphics.m_280411_(checkerboard, x, y, (int)clippedWidth, (int)clippedHeight, 0.0f, 0.0f, uvWidth, uvHeight, textureSize, textureSize);
    }
}

