/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.util;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.mixin.NativeImageAccess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.lwjgl.system.MemoryUtil;

public class NativeImageUtil {
    private NativeImageUtil() {
    }

    public static NativeImage cropImage(NativeImage src, int xOffset, int yOffset, int width, int height) {
        int srcWidth = src.m_84982_();
        int srcHeight = src.m_85084_();
        if (xOffset < 0 || yOffset < 0 || xOffset + width > srcWidth || yOffset + height > srcHeight) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Image size {}x{} is invalid. Valid size: {}x{} at y {}", new Object[]{srcWidth, srcHeight, width, height, yOffset});
            return src;
        }
        NativeImage out = new NativeImage(width, height, true);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int color = src.m_84985_(x + xOffset, y + yOffset);
                out.m_84988_(x, y, color);
            }
        }
        return out;
    }

    public static NativeImage scaleImage(NativeImage src, double scale) {
        int width = (int)Math.round((double)src.m_84982_() * scale);
        int height = (int)Math.round((double)src.m_85084_() * scale);
        NativeImage scaled = new NativeImage(width, height, true);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int srcX = (int)((double)x / scale);
                int srcY = (int)((double)y / scale);
                scaled.m_84988_(x, y, src.m_84985_(srcX, srcY));
            }
        }
        return scaled;
    }

    public static void writePixelsRGBA(NativeImage image, ByteBuffer buffer) {
        int[] pixelsABGR;
        for (int abgr : pixelsABGR = image.m_266370_()) {
            int a = abgr >> 24 & 0xFF;
            int b = abgr >> 16 & 0xFF;
            int g = abgr >> 8 & 0xFF;
            int r = abgr & 0xFF;
            buffer.put((byte)r);
            buffer.put((byte)g);
            buffer.put((byte)b);
            buffer.put((byte)a);
        }
        buffer.flip();
    }

    public static NativeImage readLarge(byte[] bytes) throws IOException {
        ByteBuffer buffer = null;
        try {
            buffer = MemoryUtil.memAlloc((int)bytes.length);
            buffer.put(bytes);
            buffer.rewind();
            NativeImage nativeImage = NativeImage.m_85062_((ByteBuffer)buffer);
            return nativeImage;
        }
        finally {
            if (buffer != null) {
                MemoryUtil.memFree((Buffer)buffer);
            }
        }
    }

    public static byte[] getBytes(NativeImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(baos);
        boolean success = ((NativeImageAccess)image).invokeWriteToChannel(channel);
        channel.close();
        if (!success) {
            throw new IOException("Failed to write NativeImage to PNG bytes.");
        }
        return baos.toByteArray();
    }
}

