/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.util;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsUtil {
    public static final int IMAGE_SIZE_MIN = 8;
    public static final int IMAGE_SIZE_MAX = 128;
    public static final int IMAGE_SIZE_STEP = 8;
    public static final double SCALE_AUTO_PREFERRED = 0.0;
    public static final double SCALE_AUTO_THRESHOLD_MAX = 0.49;
    public static final double SCALE = 1.0;
    public static final double SCALE_MIN = 0.0;
    public static final double SCALE_MAX = 8.0;
    public static final double SCALE_STEP = 0.05;
    public static final int X_HOT = 0;
    public static final int Y_HOT = 0;
    public static final int HOT_MIN = 0;
    public static final int HOT_STEP = 1;
    public static final int GLOBAL_HOT_MAX = 127;
    public static final boolean ENABLED = true;

    private SettingsUtil() {
    }

    public static void assertImageSize(int imageWidth, int imageHeight) throws IOException {
        if (imageWidth < 8 || imageWidth > 128 || imageWidth % 8 != 0) {
            throw new IOException("Unsupported image width: " + imageWidth);
        }
        if (imageHeight % imageWidth != 0) {
            throw new IOException("Image height must be divisible by width: " + imageHeight + " % " + imageWidth);
        }
    }

    public static boolean isAutoScale(double scale) {
        return scale <= 0.49;
    }

    @Nullable
    public static Component getAutoText(double scale) {
        return SettingsUtil.isAutoScale(scale) ? Component.m_237115_((String)"options.guiScale.auto") : null;
    }

    public static double getAutoScale(double scale) {
        if (SettingsUtil.isAutoScale(scale)) {
            OptionInstance guiScale = Minecraft.m_91087_().f_91066_.m_231928_();
            int max = Integer.MAX_VALUE;
            int guiScaleValue = (Integer)guiScale.m_231551_();
            OptionInstance.ValueSet valueSet = guiScale.m_231555_();
            if (valueSet instanceof OptionInstance.ClampingLazyMaxIntRange) {
                OptionInstance.ClampingLazyMaxIntRange range = (OptionInstance.ClampingLazyMaxIntRange)valueSet;
                max = range.m_214118_();
            }
            return guiScaleValue != 0 ? (double)Math.min(max, guiScaleValue) : Minecraft.m_91087_().m_91268_().m_85449_();
        }
        return scale;
    }

    public static double sanitizeScale(double scale) {
        double clampedScale = SettingsUtil.clamp(scale, 0.0, 8.0);
        double mappedScale = (double)Math.round(clampedScale / 0.05) * 0.05;
        if (SettingsUtil.isAutoScale(mappedScale)) {
            return 0.0;
        }
        return (double)Math.round(mappedScale * 100.0) / 100.0;
    }

    public static int sanitizeHotspot(int hotspot, int imageWidth) {
        return SettingsUtil.clamp(hotspot, 0, imageWidth - 1);
    }

    public static int sanitizeHotspot(int hotspot, @NotNull Cursor cursor) {
        return SettingsUtil.sanitizeHotspot(hotspot, cursor.isLoaded() ? cursor.getTextureWidth() : 128);
    }

    public static int sanitizeHotspot(double hotspot, @NotNull Cursor cursor) {
        return SettingsUtil.sanitizeHotspot((int)hotspot, cursor);
    }

    public static int sanitizeGlobalHotspot(int hotspot) {
        return SettingsUtil.clamp(hotspot, 0, 127);
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int getMaxHotspot(Cursor cursor) {
        if (cursor != null && cursor.isLoaded()) {
            return cursor.getTextureWidth() - 1;
        }
        return 127;
    }

    public static int getMaxHotspot(Collection<Cursor> cursors) {
        int max = -1;
        for (Cursor cursor : cursors) {
            int maxHotspot;
            if (!cursor.isLoaded() || (maxHotspot = SettingsUtil.getMaxHotspot(cursor)) <= max) continue;
            max = maxHotspot;
        }
        return max != -1 ? max : 127;
    }

    public static boolean equalSettings(@Nullable Config.Settings a, @Nullable Config.Settings b, boolean excludeGlobal) {
        if (Objects.equals(a, b)) {
            return true;
        }
        if (a != null && b != null) {
            boolean equal;
            boolean bl = equal = a.isEnabled() == b.isEnabled() && Objects.equals(a.isAnimated(), b.isAnimated());
            if (!excludeGlobal || !MinecraftCursor.CONFIG.getGlobal().isXHotActive()) {
                equal &= a.getXHot() == b.getXHot();
            }
            if (!excludeGlobal || !MinecraftCursor.CONFIG.getGlobal().isYHotActive()) {
                equal &= a.getYHot() == b.getYHot();
            }
            if (!excludeGlobal || !MinecraftCursor.CONFIG.getGlobal().isScaleActive()) {
                equal &= Double.compare(a.getScale(), b.getScale()) == 0;
            }
            return equal;
        }
        return false;
    }

    public static <E> void forEach(E[] arr, Consumer<E> action) {
        for (E e : arr) {
            action.accept(e);
        }
    }
}

