/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.gui.screen.ConfigurationScreen;
import io.github.fishstiz.cursors_extended.resource.BuiltinCursorResourcePack;
import io.github.fishstiz.cursors_extended.resource.CursorTextureLoader;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@Mod(value="cursors_extended", dist={Dist.CLIENT})
public class CursorsExtendedNeoForge {
    public CursorsExtendedNeoForge(ModContainer modContainer, IEventBus modEventBus) {
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, screen) -> new ConfigurationScreen(screen)));
        modEventBus.addListener(event -> {
            CursorsExtendedNeoForge.registerCursorPack(event, BuiltinCursorResourcePack.DEFAULT_AUTO);
            CursorsExtendedNeoForge.registerCursorPack(event, BuiltinCursorResourcePack.LEGACY);
        });
        modEventBus.addListener(event -> event.addListener(CursorTextureLoader.getDir(), (PreparableReloadListener)CursorsExtended.getInstance().getLoader()));
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, event -> CursorsExtended.getInstance().onClientStarted(event.getClient()));
        NeoForge.EVENT_BUS.addListener(event -> CursorsExtended.getInstance().getDisplay().setVisibleScreen(event.getScreen()));
        NeoForge.EVENT_BUS.addListener(event -> CursorsExtended.getInstance().getDisplay().setVisibleScreen(null));
    }

    private static void registerCursorPack(AddPackFindersEvent event, BuiltinCursorResourcePack pack) {
        event.addPackFinders(CursorsExtended.loc("resourcepacks/" + pack.getLocation().getPath()), PackType.CLIENT_RESOURCES, pack.getDisplayName(), PackSource.BUILT_IN, false, Pack.Position.TOP);
    }
}

