/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.compat;

import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.compat.CursorStateTracker;
import io.github.fishstiz.cursors_extended.compat.ModCursor;
import io.github.fishstiz.cursors_extended.compat.ModCursorState;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

final class CursorStateTrackerImpl
implements CursorStateTracker {
    private static volatile boolean tracking = false;
    private final Map<Long, ModCursor> cursors = new Long2ObjectOpenHashMap();
    private final Map<Long, Map<String, ModCursorState>> states = new Long2ObjectOpenHashMap();
    private final Map<Long, ModCursorState> latestStates = new Long2ObjectOpenHashMap();

    private CursorStateTrackerImpl() {
        tracking = true;
        CursorsExtended.LOGGER.info("[cursors_extended] Found mod creating its own cursors outside the vanilla API. Initialized cursor state tracker.");
    }

    static CursorStateTracker getOrDefault() {
        return !tracking ? DefaultTracker.INSTANCE : Holder.INSTANCE;
    }

    static StackWalker getStackWalker() {
        return Holder.STACK_WALKER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trackCursor(ModCursor modCursor) {
        Map<Long, ModCursor> map = this.cursors;
        synchronized (map) {
            this.cursors.put(modCursor.handle(), modCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void untrackCursor(ModCursor modCursor) {
        Map<Long, ModCursor> map = this.cursors;
        synchronized (map) {
            this.cursors.remove(modCursor.handle());
        }
    }

    @Override
    public boolean isTracking() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ModCursor getCursor(long handle) {
        Map<Long, ModCursor> map = this.cursors;
        synchronized (map) {
            return this.cursors.get(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCursor(String source, long window, CursorType cursorType, boolean custom) {
        Map windowStates = this.states.computeIfAbsent(window, k -> new Object2ObjectOpenHashMap());
        ModCursorState state = (ModCursorState)windowStates.get(source);
        if (state == null) {
            state = new ModCursorState(cursorType, custom);
            windowStates.put(source, state);
            CursorsExtended.LOGGER.info("[cursors_extended] Tracking cursor state from '{}'", (Object)source);
        } else {
            state.update(cursorType, custom);
        }
        Map<Long, ModCursorState> map = this.latestStates;
        synchronized (map) {
            ModCursorState currentLatest = this.latestStates.get(window);
            if (this.shouldReplaceState(currentLatest, state)) {
                this.latestStates.put(window, state);
            }
        }
    }

    @Override
    public void resetCursor(long window, String source) {
        this.setCursor(source, window, CursorType.DEFAULT, false);
    }

    @Override
    public void setCursor(long window, ModCursor cursor) {
        this.setCursor(cursor.source(), window, cursor.cursorType(), cursor.custom());
    }

    private boolean shouldReplaceState(ModCursorState current, ModCursorState other) {
        boolean otherDefault;
        if (current == null) {
            return true;
        }
        boolean isCurrentCustom = current.isCustom();
        boolean isOtherCustom = other.isCustom();
        if (isOtherCustom != isCurrentCustom) {
            return isOtherCustom;
        }
        if (isCurrentCustom) {
            return other.getTimestamp() > current.getTimestamp();
        }
        boolean currentDefault = !CursorTypeUtil.nonDefault(current.getCursorType());
        boolean bl = otherDefault = !CursorTypeUtil.nonDefault(other.getCursorType());
        if (currentDefault != otherDefault) {
            return !otherDefault;
        }
        return other.getTimestamp() > current.getTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CursorType getCurrentCursor(long window) {
        ModCursorState state;
        Map<Long, ModCursorState> map = this.latestStates;
        synchronized (map) {
            state = this.latestStates.get(window);
        }
        return state == null ? CursorType.DEFAULT : state.getCursorType();
    }

    static final class DefaultTracker
    implements CursorStateTracker {
        private static final CursorStateTracker INSTANCE = new DefaultTracker();

        DefaultTracker() {
        }

        @Override
        public void trackCursor(ModCursor cursor) {
            Holder.INSTANCE.trackCursor(cursor);
        }

        @Override
        public void resetCursor(long window, String source) {
            Holder.INSTANCE.resetCursor(window, source);
        }

        @Override
        public void setCursor(long window, ModCursor cursor) {
            Holder.INSTANCE.setCursor(window, cursor);
        }
    }

    private static final class Holder {
        static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        static final CursorStateTracker INSTANCE = new CursorStateTrackerImpl();

        private Holder() {
        }
    }
}

