/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor.debug;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.debug.CursorDebugRenderer;
import io.github.fishstiz.cursors_extended.platform.Services;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

class CursorDebugRendererImpl
implements CursorDebugRenderer {
    private static final float TEXT_SCALE = 0.75f;
    private final Component screenLabel = Component.literal((String)"S: ").withColor(-13394945);
    private final Component deepestLabel = Component.literal((String)"D: ").withColor(-16711936);
    private final Component inspectedLabel = Component.literal((String)"I: ").withColor(-65536);
    private final Component virtualModeLabel = Component.literal((String)"Virtual Mode: ").withStyle(ChatFormatting.GOLD);
    private ScreenRectangle inspectedBounds;
    private String inspectedElement;

    CursorDebugRendererImpl() {
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setLastCursorAt(GuiEventListener inspected, double mouseX, double mouseY) {
        if (CursorTypeUtil.isHovered(inspected, mouseX, mouseY)) {
            this.inspectedBounds = this.getBounds(inspected);
            this.inspectedElement = this.getClassName(inspected);
        }
    }

    @Override
    public void render(Minecraft minecraft, Supplier<@Nullable Screen> visibleScreen, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Screen screen = visibleScreen.get();
        if (screen != null) {
            ScreenRectangle screenRectangle = this.getBounds((GuiEventListener)screen);
            this.renderScreenName(minecraft, screen, screenRectangle, guiGraphics);
            this.renderInspected(minecraft, this.renderDeepest(minecraft, screen, guiGraphics, mouseX, mouseY), guiGraphics);
            this.renderVirtualInfo(minecraft, screenRectangle, guiGraphics);
        }
    }

    private ScreenRectangle renderDeepest(Minecraft minecraft, Screen screen, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GuiEventListener child = CursorDebugRendererImpl.findDeepest((ContainerEventHandler)screen, mouseX, mouseY);
        GuiEventListener inspect = child != null ? child : screen;
        ScreenRectangle bounds = this.getBounds(inspect);
        MutableComponent label = this.deepestLabel.copy().append(this.getClassName(inspect));
        this.renderInfo(minecraft, guiGraphics, bounds, (Component)label, Position.TOP_LEFT, true);
        return bounds;
    }

    private void renderInspected(Minecraft minecraft, ScreenRectangle container, GuiGraphics guiGraphics) {
        if (this.inspectedBounds != null) {
            MutableComponent label = this.inspectedLabel.copy().append(this.inspectedElement);
            int index = this.inspectedBounds.top() != container.top() ? 0 : 1;
            this.renderInfo(minecraft, guiGraphics, this.inspectedBounds, (Component)label, Position.TOP_LEFT, index, true);
        }
    }

    private void renderScreenName(Minecraft minecraft, Screen screen, ScreenRectangle bounds, GuiGraphics guiGraphics) {
        MutableComponent label = this.screenLabel.copy().append(this.getClassName((GuiEventListener)screen));
        this.renderInfo(minecraft, guiGraphics, bounds, (Component)label, Position.BOTTOM_RIGHT, false);
    }

    private void renderVirtualInfo(Minecraft minecraft, ScreenRectangle screenBounds, GuiGraphics guiGraphics) {
        MutableComponent virtualMode = this.virtualModeLabel.copy().append(CursorsExtended.getInstance().getDisplay().isVirtual() ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
        this.renderInfo(minecraft, guiGraphics, screenBounds, (Component)virtualMode, Position.TOP_RIGHT, false);
    }

    private void renderInfo(Minecraft minecraft, GuiGraphics guiGraphics, ScreenRectangle bounds, Component label, Position pos, boolean outline) {
        this.renderInfo(minecraft, guiGraphics, bounds, label, pos, 0, outline);
    }

    private void renderInfo(Minecraft minecraft, GuiGraphics guiGraphics, ScreenRectangle bounds, Component label, Position pos, int index, boolean outline) {
        TextColor textColor = label.getStyle().getColor();
        int color = 0xFF000000 | (textColor != null ? textColor.getValue() : -1);
        int textX = pos.getX(minecraft, bounds, label, 0.75f);
        int textY = pos.getY(minecraft, bounds, index, 0.75f);
        Matrix3x2fStack matrix3x2fStack = guiGraphics.pose().pushMatrix();
        guiGraphics.nextStratum();
        if (outline) {
            DrawUtil.renderOutline(guiGraphics, bounds.left(), bounds.top(), bounds.width(), bounds.height(), color);
        }
        matrix3x2fStack.translate(0.75f, 0.75f);
        matrix3x2fStack.scale(0.75f, 0.75f);
        guiGraphics.drawString(minecraft.font, label, textX, textY, color);
        matrix3x2fStack.popMatrix();
    }

    private ScreenRectangle getBounds(@Nullable GuiEventListener element) {
        if (element instanceof LayoutElement) {
            LayoutElement layoutElement = (LayoutElement)element;
            return layoutElement.getRectangle();
        }
        return element != null ? element.getRectangle() : ScreenRectangle.empty();
    }

    private String getClassName(GuiEventListener element) {
        String namespace = Services.PLATFORM.isDevelopmentEnvironment() ? "named" : "intermediary";
        return Services.PLATFORM.unmapClassName(namespace, element.getClass().getName());
    }

    @Nullable
    private static GuiEventListener findDeepest(ContainerEventHandler parent, double mouseX, double mouseY) {
        if (CursorTypeUtil.isHovered((GuiEventListener)parent, mouseX, mouseY)) {
            for (GuiEventListener child : parent.children()) {
                ContainerEventHandler nestedParent;
                GuiEventListener nestedChild;
                if (child instanceof ContainerEventHandler && (nestedChild = CursorDebugRendererImpl.findDeepest(nestedParent = (ContainerEventHandler)child, mouseX, mouseY)) != null) {
                    return nestedChild;
                }
                if (!CursorTypeUtil.isHovered(child, mouseX, mouseY)) continue;
                return child;
            }
        }
        return null;
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

        private static final int PADDING = 2;

        public int getX(Minecraft minecraft, ScreenRectangle bounds, Component text, float scale) {
            int screenWidth = minecraft.getWindow().getGuiScaledWidth();
            int textWidth = minecraft.font.width((FormattedText)text);
            int x = switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> (int)((float)(bounds.left() + 2) / scale);
                case 1, 3 -> {
                    int unscaledX = bounds.left() + bounds.width() - (int)((float)textWidth * scale) - 2;
                    yield (int)((float)unscaledX / scale);
                }
            };
            if ((float)(x + textWidth) * scale > (float)screenWidth && (x = (int)(((float)screenWidth - (float)textWidth * scale - 2.0f) / scale)) < 0) {
                x = 0;
            }
            return x;
        }

        public int getY(Minecraft minecraft, ScreenRectangle bounds, int index, float scale) {
            int screenHeight = minecraft.getWindow().getGuiScaledHeight();
            Objects.requireNonNull(minecraft.font);
            int textHeight = 9;
            int offsetY = index * textHeight;
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> (int)((float)(bounds.top() + 2 + offsetY) / scale);
                case 2, 3 -> bounds.height() == 0 && bounds.width() == 0 ? (int)((float)(screenHeight - textHeight - 2 - offsetY) / scale) : (int)((float)(bounds.top() - 2 + Math.max(0, bounds.height() - textHeight) + offsetY) / scale);
            };
        }
    }
}

