/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.screen;

import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CatalogItem(@NotNull String id, @NotNull Component text, @Nullable Prefix prefix) {
    public CatalogItem(@NotNull String id, @NotNull Component text, @Nullable Prefix prefix) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(text);
    }

    public CatalogItem(String id, Component text) {
        this(id, text, null);
    }

    public CatalogItem withPrefix(UnaryOperator<Prefix> prefixModifier) {
        return new CatalogItem(this.id, this.text, (Prefix)prefixModifier.apply(this.prefix));
    }

    public CatalogItem withText(UnaryOperator<Component> textModifier) {
        return new CatalogItem(this.id, (Component)textModifier.apply(this.text), this.prefix);
    }

    @Override
    public boolean equals(Object other) {
        CatalogItem otherItem;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return other instanceof CatalogItem && (otherItem = (CatalogItem)other).id().equals(this.id());
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @FunctionalInterface
    public static interface Prefix {
        public int render(GuiGraphics var1, Font var2, CatalogItem var3, LayoutElement var4, int var5, int var6, int var7, float var8);
    }
}

