/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.gui.MouseEvent;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderWidget
extends AbstractSliderButton {
    private final Consumer<Double> listener;
    private final Component prefix;
    @Nullable
    private final Component suffix;
    @Nullable
    private final TextMapper textMapper;
    @Nullable
    private final MouseEventListener mouseEventListener;
    private final double min;
    private final double max;
    private final double step;
    private double mappedValue;
    private double previousAppliedValue;

    public SliderWidget(int x, int y, int width, int height, double mappedValue, double min, double max, double step, @NotNull Consumer<Double> listener, @NotNull Component prefix, @Nullable Component suffix, @Nullable TextMapper textMapper, @Nullable MouseEventListener mouseEventListener) {
        super(x, y, width, height, prefix, mappedValue);
        this.listener = listener;
        this.prefix = prefix;
        this.suffix = suffix;
        this.textMapper = textMapper;
        this.min = min;
        this.max = max;
        this.step = step;
        this.mappedValue = mappedValue;
        this.mouseEventListener = mouseEventListener;
        this.value = this.unmapValue(this.mappedValue);
        this.mapValue();
        this.updateMessage();
        this.previousAppliedValue = this.mappedValue;
    }

    public SliderWidget(double mappedValue, double min, double max, double step, @NotNull Consumer<Double> listener, @NotNull Component prefix, @Nullable Component suffix, @Nullable TextMapper textMapper, @Nullable MouseEventListener mouseEventListener) {
        this(0, 0, 150, 20, mappedValue, min, max, step, listener, prefix, suffix, textMapper, mouseEventListener);
    }

    public SliderWidget(double mappedValue, double min, double max, double step, @NotNull Consumer<Double> listener, @NotNull Component prefix, @Nullable Component suffix) {
        this(0, 0, 150, 20, mappedValue, min, max, step, listener, prefix, suffix, null, null);
    }

    protected void updateMessage() {
        Component mappedText;
        MutableComponent label = this.prefix.copy().append(": ");
        MutableComponent message = null;
        if (this.textMapper != null && (mappedText = this.textMapper.getText(this.mappedValue)) != null) {
            message = label.append(mappedText);
        }
        if (message == null) {
            String formatted = String.format(this.step % 1.0 == 0.0 ? "%.0f" : "%.2f", this.mappedValue);
            message = label.append(formatted);
            if (this.suffix != null) {
                message.append(this.suffix);
            }
        }
        this.setMessage((Component)message);
    }

    public void onClick(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        super.onClick(mouseButtonEvent, doubleClick);
        this.sendMouseEvent(MouseEvent.CLICK);
    }

    protected void onDrag(MouseButtonEvent mouseButtonEvent, double dragX, double dragY) {
        super.onDrag(mouseButtonEvent, dragX, dragY);
        this.sendMouseEvent(MouseEvent.DRAG);
    }

    public void onRelease(MouseButtonEvent mouseButtonEvent) {
        super.onRelease(mouseButtonEvent);
        this.setFocused(false);
        this.sendMouseEvent(MouseEvent.RELEASE);
    }

    private void sendMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseEventListener != null) {
            this.mouseEventListener.onMouseEvent(this, mouseEvent, this.mappedValue);
        }
    }

    protected void applyValue() {
        this.mapValue();
        if (this.previousAppliedValue != this.mappedValue) {
            this.previousAppliedValue = this.mappedValue;
            this.listener.accept(this.mappedValue);
        }
    }

    private double unmapValue(double mappedValue) {
        double clampedValue = Math.max(this.min, Math.min(mappedValue, this.max));
        return (clampedValue - this.min) / (this.max - this.min);
    }

    private void mapValue() {
        double scaledValue = this.min + this.value * (this.max - this.min);
        this.mappedValue = (double)Math.round(scaledValue / this.step) * this.step;
    }

    public double getMappedValue() {
        return this.mappedValue;
    }

    public void applyMappedValue(double translatedValue) {
        this.value = this.unmapValue(translatedValue);
        this.applyValue();
        this.updateMessage();
    }

    public Component getPrefix() {
        return this.prefix;
    }

    @FunctionalInterface
    public static interface TextMapper {
        @Nullable
        public Component getText(double var1);
    }

    @FunctionalInterface
    public static interface MouseEventListener {
        public void onMouseEvent(@NotNull SliderWidget var1, @NotNull MouseEvent var2, double var3);
    }
}

