/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.AnimationData;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.config.ConfigLoader;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorResourceLoader {
    private static final String ANIMATION_TYPE = ".mcmeta";
    private static final class_2960 SETTINGS_LOCATION = MinecraftCursor.loc("atlases/cursors.json");
    private static final class_2960 DIR = MinecraftCursor.loc("textures/cursors/");
    private static Config.Resource resourceConfig;

    private CursorResourceLoader() {
    }

    public static class_2960 getDirectory() {
        return DIR;
    }

    public static void reload(class_3300 manager) {
        CursorResourceLoader.onReload();
        CursorResourceLoader.loadResourceSettings(manager);
        CursorResourceLoader.loadCursorTextures(manager);
        class_310.method_1551().execute(CursorResourceLoader::onReload);
    }

    static void onReload() {
        CursorManager.INSTANCE.setCurrentCursor(CursorType.DEFAULT);
    }

    private static void loadResourceSettings(class_3300 manager) {
        CursorResourceLoader.getLayeredSettings(manager.method_14489(SETTINGS_LOCATION)).ifPresent(config -> {
            if (config.isDifferent(MinecraftCursor.CONFIG)) {
                MinecraftCursor.LOGGER.info("[minecraft-cursor] New resource pack settings detected, updating config...");
                MinecraftCursor.CONFIG.setHash(config.getHash());
                MinecraftCursor.CONFIG.merge((Config.Resource)config);
                MinecraftCursor.CONFIG.getGlobal().setActiveAll(false);
                MinecraftCursor.CONFIG.save();
            }
            resourceConfig = config;
        });
    }

    private static Optional<Config.Resource> getLayeredSettings(List<class_3298> configResources) {
        Config.Resource layeredResources = null;
        for (class_3298 configResource : configResources) {
            try {
                InputStream stream = configResource.method_14482();
                try {
                    Config.Resource resourceConfig = ConfigLoader.loadResource(stream);
                    if (layeredResources == null) {
                        layeredResources = resourceConfig;
                        continue;
                    }
                    layeredResources.layer(resourceConfig.getAllSettings());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load settings of resource pack '{}'", (Object)configResource.method_14480());
            }
        }
        return Optional.ofNullable(layeredResources);
    }

    public static boolean isResourceSetting(@NotNull Cursor cursor, @Nullable Config.Settings settings) {
        return SettingsUtil.equalSettings(resourceConfig.getOrCreateSettings(cursor), settings, true);
    }

    public static boolean retoreActiveResourceSettings(@NotNull Cursor cursor) {
        if (cursor.isLoaded() && resourceConfig != null) {
            MinecraftCursor.CONFIG.replaceActiveSettings(resourceConfig, cursor);
            cursor.apply(MinecraftCursor.CONFIG.getGlobal().apply(MinecraftCursor.CONFIG.getOrCreateSettings(cursor)));
            return true;
        }
        MinecraftCursor.LOGGER.error("Failed to apply resource settings for '{}'", (Object)cursor.getTypeKey());
        return false;
    }

    public static void restoreResourceSettings() {
        if (resourceConfig != null) {
            MinecraftCursor.CONFIG.setHash(resourceConfig.getHash());
            MinecraftCursor.CONFIG.merge(resourceConfig);
            for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
                cursor.apply(MinecraftCursor.CONFIG.getGlobal().apply(MinecraftCursor.CONFIG.getOrCreateSettings(cursor)));
            }
        } else {
            MinecraftCursor.LOGGER.error("Failed to apply resource config: Not Found.");
        }
    }

    private static void loadCursorTextures(class_3300 manager) {
        for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
            Config.Settings settings = MinecraftCursor.CONFIG.getOrCreateSettings(cursor);
            if (!MinecraftCursor.CONFIG.isDeferredLoading() || settings.isEnabled()) {
                CursorResourceLoader.loadCursorTexture(manager, cursor, settings);
                continue;
            }
            MinecraftCursor.LOGGER.info("[minecraft-cursor] Skipped loading of disabled cursor '{}'.", (Object)cursor.getTypeKey());
        }
    }

    public static boolean loadCursorTexture(class_3300 manager, Cursor cursor) {
        return CursorResourceLoader.loadCursorTexture(manager, cursor, MinecraftCursor.CONFIG.getOrCreateSettings(cursor));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean loadCursorTexture(class_3300 manager, Cursor cursor, Config.Settings settings) {
        MinecraftCursor.LOGGER.info("[minecraft-cursor] Loading cursor '{}'...", (Object)cursor.getTypeKey());
        class_2960 location = cursor.getLocation();
        Optional cursorResource = manager.method_14486(location);
        if (cursorResource.isEmpty()) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Cursor Type: '{}' not found", (Object)cursor.getTypeKey());
            return false;
        }
        try (InputStream cursorStream = ((class_3298)cursorResource.get()).method_14482();){
            boolean bl;
            block15: {
                class_1011 image = class_1011.method_4309((InputStream)cursorStream);
                try {
                    AnimationData animation = CursorResourceLoader.loadAnimation(manager, location, (class_3298)cursorResource.get());
                    CursorManager.INSTANCE.loadCursor(cursor, image, MinecraftCursor.CONFIG.getGlobal().apply(settings), animation);
                    bl = true;
                    if (image == null) break block15;
                }
                catch (Throwable throwable) {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                image.close();
            }
            return bl;
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load cursor at '{}': {}", (Object)location, (Object)e.getMessage());
            return false;
        }
    }

    private static AnimationData loadAnimation(class_3300 manager, class_2960 location, class_3298 cursorResource) {
        Optional animationResource = manager.method_14486(location.method_48331(ANIMATION_TYPE));
        if (animationResource.isPresent() && ((class_3298)animationResource.get()).method_14480().equals(cursorResource.method_14480())) {
            AnimationData animationData;
            block9: {
                InputStream stream = ((class_3298)animationResource.get()).method_14482();
                try {
                    animationData = ConfigLoader.loadAnimationData(stream);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load animation data for '{}'", (Object)location);
                    }
                }
                stream.close();
            }
            return animationData;
        }
        return null;
    }
}

