/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.class_156;

public class AnimationState {
    private static final long MS_PER_TICK = 50L;
    private static final Random RANDOM = new Random();
    private long lastFrameTime = 0L;
    private int currentFrame = 0;
    private boolean oscillateReversed = false;
    private List<Integer> shuffledFrames;
    private int shuffledIndex = 0;

    private boolean isNext(AnimatedCursor cursor, long currentTime) {
        return currentTime - this.lastFrameTime >= (long)cursor.getFrame(this.currentFrame).time() * 50L;
    }

    public int next(AnimatedCursor cursor) {
        long currentTime = class_156.method_658();
        if (!this.isNext(cursor, currentTime)) {
            return this.currentFrame;
        }
        this.lastFrameTime = currentTime;
        this.currentFrame = switch (cursor.getMode()) {
            default -> throw new MatchException(null, null);
            case AnimationMode.LOOP, AnimationMode.LOOP_REVERSE -> (this.currentFrame + 1) % cursor.getFrameCount();
            case AnimationMode.FORWARDS, AnimationMode.REVERSE -> Math.min(this.currentFrame + 1, cursor.getFrameCount() - 1);
            case AnimationMode.OSCILLATE -> {
                boolean v1 = this.oscillateReversed = this.currentFrame != 0 && (this.currentFrame == cursor.getFrameCount() - 1 || this.oscillateReversed);
                if (this.oscillateReversed) {
                    yield this.currentFrame - 1;
                }
                yield this.currentFrame + 1;
            }
            case AnimationMode.RANDOM -> {
                int newFrame;
                while ((newFrame = RANDOM.nextInt(cursor.getFrameCount())) == this.currentFrame) {
                }
                yield newFrame;
            }
            case AnimationMode.RANDOM_CYCLE -> {
                if (this.shuffledFrames == null || this.shuffledIndex >= this.shuffledFrames.size()) {
                    this.shuffledFrames = new ArrayList<Integer>(cursor.getFrameCount());
                    for (int i = 0; i < cursor.getFrameCount(); ++i) {
                        this.shuffledFrames.add(i);
                    }
                    Collections.shuffle(this.shuffledFrames, RANDOM);
                    this.shuffledIndex = 0;
                }
                yield this.shuffledFrames.get(this.shuffledIndex++);
            }
        };
        return this.currentFrame;
    }

    public void reset() {
        this.lastFrameTime = class_156.method_658();
        this.currentFrame = 0;
        this.oscillateReversed = false;
        this.shuffledFrames = null;
        this.shuffledIndex = 0;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }
}

