/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.CursorResourceLoader;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.util.NativeImageUtil;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryUtil;

public class Cursor {
    private static final String IMG_TYPE = ".png";
    @Nullable
    protected final Consumer<Cursor> onLoad;
    private final CursorType type;
    private final class_2960 location;
    private class_2561 text;
    private String base64Image;
    private double scale;
    private int xhot;
    private int yhot;
    private boolean enabled;
    private boolean loaded;
    private int textureWidth;
    private int textureHeight;
    private long id = 0L;

    public Cursor(CursorType type, @Nullable Consumer<Cursor> onLoad) {
        this.type = type;
        this.onLoad = onLoad;
        this.location = CursorResourceLoader.getDirectory().method_48331(type.getKey() + IMG_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadImage(@NotNull class_1011 image, Config.Settings settings) throws IOException {
        try {
            int imageWidth = image.method_4307();
            int imageHeight = image.method_4323();
            SettingsUtil.assertImageSize(imageWidth, imageHeight);
            try (class_1011 croppedImage = null;){
                if (image.method_4323() > imageWidth) {
                    croppedImage = NativeImageUtil.cropImage(image, 0, 0, imageWidth, imageWidth);
                }
                class_1011 validImage = croppedImage != null ? croppedImage : image;
                this.base64Image = NativeImageUtil.toBase64String(validImage);
                this.enabled = settings.isEnabled();
                this.textureWidth = imageWidth;
                this.textureHeight = imageHeight;
                this.create(validImage, settings.getScale(), settings.getXHot(), settings.getYHot());
            }
        }
        catch (Exception e) {
            this.loaded = false;
            this.destroy();
            throw e;
        }
    }

    protected void updateImage(double scale, int xhot, int yhot) {
        if (!this.isLoaded()) {
            return;
        }
        try (class_1011 image = NativeImageUtil.fromBase64String(this.base64Image);){
            this.create(image, scale, xhot, yhot);
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.error("Error updating image of {}: {}", (Object)this.type, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void create(class_1011 image, double scale, int xhot, int yhot) {
        long previousId;
        long glfwImageAddress;
        block22: {
            class_1011 scaledImage;
            ByteBuffer pixels;
            block18: {
                block20: {
                    block19: {
                        scale = SettingsUtil.sanitizeScale(scale);
                        xhot = SettingsUtil.sanitizeHotspot(xhot, image.method_4307());
                        yhot = SettingsUtil.sanitizeHotspot(yhot, image.method_4307());
                        glfwImageAddress = 0L;
                        previousId = this.id;
                        pixels = null;
                        double autoScaled = SettingsUtil.getAutoScale(scale);
                        scaledImage = scale == 1.0 ? image : NativeImageUtil.scaleImage(image, autoScaled);
                        int scaledXHot = scale == 1.0 ? xhot : (int)Math.round((double)xhot * autoScaled);
                        int scaledYHot = scale == 1.0 ? yhot : (int)Math.round((double)yhot * autoScaled);
                        int scaledWidth = scaledImage.method_4307();
                        int scaledHeight = scaledImage.method_4323();
                        GLFWImage glfwImage = GLFWImage.create();
                        pixels = MemoryUtil.memAlloc((int)(scaledWidth * scaledHeight * 4));
                        NativeImageUtil.writePixelsRGBA(scaledImage, pixels);
                        glfwImage.set(scaledWidth, scaledHeight, pixels);
                        glfwImageAddress = glfwImage.address();
                        ExternalCursorTracker.trackInternalCursor(glfwImageAddress);
                        this.id = GLFW.glfwCreateCursor((GLFWImage)glfwImage, (int)scaledXHot, (int)scaledYHot);
                        if (this.id != 0L) break block18;
                        MinecraftCursor.LOGGER.error("[minecraft-cursor] Error creating cursor '{}'. ", (Object)this.type.getKey());
                        if (scaledImage == null) break block19;
                        scaledImage.close();
                    }
                    if (pixels == null) break block20;
                    MemoryUtil.memFree((Buffer)pixels);
                }
                if (previousId != 0L && this.id != previousId) {
                    GLFW.glfwDestroyCursor((long)previousId);
                }
                if (glfwImageAddress != 0L) {
                    ExternalCursorTracker.consumeInternalCursor(glfwImageAddress);
                }
                return;
            }
            try {
                block21: {
                    this.loaded = true;
                    this.scale = scale;
                    this.xhot = xhot;
                    this.yhot = yhot;
                    if (this.onLoad != null) {
                        this.onLoad.accept(this);
                    }
                    break block21;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        if (scaledImage != null) {
                            scaledImage.close();
                        }
                    }
                }
                if (pixels == null) break block22;
            }
            catch (Throwable throwable) {
                if (pixels != null) {
                    MemoryUtil.memFree(pixels);
                }
                if (previousId != 0L && this.id != previousId) {
                    GLFW.glfwDestroyCursor((long)previousId);
                }
                if (glfwImageAddress != 0L) {
                    ExternalCursorTracker.consumeInternalCursor(glfwImageAddress);
                }
                throw throwable;
            }
            MemoryUtil.memFree((Buffer)pixels);
        }
        if (previousId != 0L && this.id != previousId) {
            GLFW.glfwDestroyCursor((long)previousId);
        }
        if (glfwImageAddress != 0L) {
            ExternalCursorTracker.consumeInternalCursor(glfwImageAddress);
        }
    }

    public void destroy() {
        if (this.id != 0L) {
            GLFW.glfwDestroyCursor((long)this.id);
            this.id = 0L;
        }
    }

    public void reload() {
        if (this.isLoaded()) {
            this.updateImage(this.getScale(), this.getXHot(), this.getYHot());
        }
    }

    public void apply(Config.Settings settings) {
        this.enable(settings.isEnabled());
        this.updateImage(settings.getScale(), settings.getXHot(), settings.getYHot());
    }

    public void enable(boolean enabled) {
        boolean previous = this.enabled;
        this.enabled = enabled;
        if (previous != this.enabled && this.isLoaded() && this.onLoad != null) {
            this.onLoad.accept(this);
        }
    }

    public class_2960 getLocation() {
        return this.location;
    }

    public long getId() {
        return this.enabled ? this.id : 0L;
    }

    @NotNull
    public CursorType getType() {
        return this.type;
    }

    @NotNull
    public String getTypeKey() {
        return this.type.getKey();
    }

    @NotNull
    public class_2561 getText() {
        if (this.text == null) {
            this.text = class_2561.method_43471((String)("minecraft-cursor.options.cursor-type." + this.type.getKey()));
        }
        return this.text;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.updateImage(scale, this.xhot, this.yhot);
    }

    public int getXHot() {
        return this.xhot;
    }

    public void setXHot(double xhot) {
        this.setXHot((int)xhot);
    }

    public void setXHot(int xhot) {
        this.updateImage(this.scale, xhot, this.yhot);
    }

    public int getYHot() {
        return this.yhot;
    }

    public void setYHot(double yhot) {
        this.setYHot((int)yhot);
    }

    public void setYHot(int yhot) {
        this.updateImage(this.scale, this.xhot, yhot);
    }

    public boolean isEnabled() {
        return this.enabled && this.isLoaded();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public int getTextureWidth() throws IllegalStateException {
        this.assertLoaded();
        return this.textureWidth;
    }

    public int getTextureHeight() throws IllegalStateException {
        this.assertLoaded();
        return this.textureHeight;
    }

    private void assertLoaded() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Cursor has not been loaded");
        }
    }
}

