/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.CursorTypeRegistrar;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import io.github.fishstiz.minecraftcursor.config.AnimationData;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationState;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1011;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public final class CursorManager
implements CursorTypeRegistrar {
    public static final CursorManager INSTANCE = new CursorManager();
    private final LinkedHashMap<String, Cursor> cursors = new LinkedHashMap();
    private final TreeMap<Integer, String> overrides = new TreeMap();
    private final AnimationState animationState = new AnimationState();
    @NotNull
    private Cursor currentCursor = new Cursor(CursorType.of((String)""), null);

    private CursorManager() {
    }

    public void register(CursorType ... cursorTypes) {
        for (CursorType cursorType : cursorTypes) {
            this.register(cursorType);
        }
    }

    public CursorType register(String key) {
        return this.register(CursorType.of((String)key));
    }

    private CursorType register(CursorType cursorType) {
        String key = cursorType.getKey();
        if (key.isEmpty()) {
            throw new NullPointerException("Cursor type key cannot be empty.");
        }
        if (this.cursors.containsKey(key)) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Cursor type '{}' is already registered.", (Object)key);
            return cursorType;
        }
        this.cursors.put(key, new Cursor(cursorType, this::onLoad));
        return cursorType;
    }

    public void loadCursor(Cursor cursor, class_1011 image, Config.Settings settings, @Nullable AnimationData animation) throws IOException {
        boolean animated;
        if (!this.cursors.containsKey(cursor.getTypeKey())) {
            throw new IllegalStateException("Attempting to load an unregistered cursor: " + cursor.getTypeKey());
        }
        boolean bl = animated = animation != null;
        if (animated != cursor instanceof AnimatedCursor) {
            cursor.destroy();
            cursor = animated ? new AnimatedCursor(cursor.getType(), this::onLoad) : new Cursor(cursor.getType(), this::onLoad);
            this.cursors.put(cursor.getTypeKey(), cursor);
        }
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            animatedCursor.loadImage(image, settings, animation);
        } else {
            cursor.loadImage(image, settings);
        }
    }

    private void onLoad(Cursor cursor) {
        Cursor appliedCursor = this.getAppliedCursor();
        if (appliedCursor.isLoaded() && appliedCursor.getId() == cursor.getId()) {
            this.reapplyCursor();
        }
    }

    public void setCurrentCursor(@NotNull CursorType type) {
        Cursor cursor;
        Cursor override = this.getOverride();
        Cursor cursor2 = cursor = override != null ? override : this.cursors.get(type.getKey());
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            if (cursor.getId() != 0L) {
                this.handleCursorAnimation(animatedCursor);
                return;
            }
        }
        if (cursor == null || !type.isDefault() && cursor.getId() == 0L || !cursor.isEnabled()) {
            cursor = this.getCursor(CursorType.DEFAULT);
        }
        this.updateCursor(cursor);
    }

    private void handleCursorAnimation(AnimatedCursor cursor) {
        Cursor currentFrameCursor;
        if (!this.getAppliedCursor().getType().isKey(cursor.getType())) {
            this.animationState.reset();
        }
        this.updateCursor((currentFrameCursor = cursor.getFrame(this.animationState.next(cursor)).cursor()).getId() != 0L ? currentFrameCursor : cursor);
    }

    private void updateCursor(Cursor cursor) {
        if (cursor == null || !MinecraftCursor.CONFIG.isAggressiveCursor() && cursor.getId() == this.currentCursor.getId() || ExternalCursorTracker.get().isCustom()) {
            return;
        }
        this.currentCursor = cursor;
        GLFW.glfwSetCursor((long)CursorTypeUtil.WINDOW, (long)this.currentCursor.getId());
    }

    public void reapplyCursor() {
        if (!ExternalCursorTracker.get().isCustom()) {
            GLFW.glfwSetCursor((long)CursorTypeUtil.WINDOW, (long)this.getAppliedCursor().getId());
        }
    }

    public void overrideCurrentCursor(CursorType type, int index) {
        Cursor cursor = this.getCursor(type);
        if (cursor != null && cursor.isEnabled()) {
            this.overrides.put(index, type.getKey());
        } else {
            this.overrides.remove(index);
        }
    }

    public void removeOverride(int index) {
        this.overrides.remove(index);
    }

    @Nullable
    public Cursor getOverride() {
        while (!this.overrides.isEmpty()) {
            Map.Entry<Integer, String> lastEntry = this.overrides.lastEntry();
            Cursor cursor = this.cursors.get(lastEntry.getValue());
            if (cursor == null || cursor.getId() == 0L) {
                this.overrides.remove(lastEntry.getKey());
                continue;
            }
            return cursor;
        }
        return null;
    }

    @NotNull
    public Cursor getAppliedCursor() {
        Cursor cursor;
        Cursor override = this.getOverride();
        Cursor cursor2 = cursor = override != null ? override : this.currentCursor;
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            return animatedCursor.getFrame(this.animationState.getCurrentFrame()).cursor();
        }
        return cursor;
    }

    public boolean isEnabled(@NotNull CursorType type) {
        Cursor cursor = this.cursors.get(type.getKey());
        if (cursor == null) {
            return false;
        }
        return cursor.isEnabled();
    }

    public boolean isEnabled(@Nullable Cursor cursor) {
        return cursor != null && this.isEnabled(cursor.getType());
    }

    @Nullable
    public Cursor getCursor(CursorType type) {
        return this.cursors.get(type.getKey());
    }

    @Nullable
    public Cursor getCursor(String type) {
        return this.cursors.get(type);
    }

    public long getCurrentId() {
        return this.getAppliedCursor().getId();
    }

    public Collection<Cursor> getCursors() {
        return this.cursors.values();
    }

    public boolean isAdaptive() {
        for (Cursor cursor : this.cursors.values()) {
            if (!cursor.isEnabled() || cursor.getType().isDefault()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnimations() {
        for (Cursor cursor : this.cursors.values()) {
            if (!(cursor instanceof AnimatedCursor)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnimated() {
        for (Cursor cursor : this.cursors.values()) {
            AnimatedCursor animatedCursor;
            if (!(cursor instanceof AnimatedCursor) || !(animatedCursor = (AnimatedCursor)cursor).isAnimated()) continue;
            return true;
        }
        return false;
    }

    public void reloadCursors() {
        this.cursors.values().forEach(Cursor::reload);
    }
}

