/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor.resolver;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorHandler;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.ElementRegistrar;
import io.github.fishstiz.minecraftcursor.cursor.handler.InternalCursorProvider;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementInspector;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementWalker;
import io.github.fishstiz.minecraftcursor.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_364;
import net.minecraft.class_4069;

public final class CursorTypeResolver
implements ElementRegistrar {
    public static final CursorTypeResolver INSTANCE = new CursorTypeResolver();
    private final List<ElementEntry<? extends class_364>> registry = new ArrayList<ElementEntry<? extends class_364>>();
    private final HashMap<String, ElementRegistrar.CursorTypeFunction<? extends class_364>> cache = new HashMap();
    private ElementInspector inspector = ElementInspector.NO_OP;
    private String lastFailedElement;

    private CursorTypeResolver() {
    }

    public <T extends class_364> void register(CursorHandler<T> cursorHandler) {
        CursorHandler.TargetElement targetElement = cursorHandler.getTargetElement();
        if (targetElement.elementClass().isPresent()) {
            this.register((Class)targetElement.elementClass().get(), (arg_0, arg_1, arg_2) -> cursorHandler.getCursorType(arg_0, arg_1, arg_2));
        } else if (targetElement.fullyQualifiedClassName().isPresent()) {
            this.register((String)targetElement.fullyQualifiedClassName().get(), (arg_0, arg_1, arg_2) -> cursorHandler.getCursorType(arg_0, arg_1, arg_2));
        } else {
            throw new NullPointerException("Could not register cursor handler: " + cursorHandler.getClass().getName() + " - Target ElementView Class and FQCN not present");
        }
    }

    public <T extends class_364> void register(String binaryName, ElementRegistrar.CursorTypeFunction<T> elementToCursorType) {
        try {
            Class<?> elementClass = Class.forName(Services.PLATFORM.mapClassName("intermediary", binaryName));
            if (!class_364.class.isAssignableFrom(elementClass)) {
                throw new ClassCastException(binaryName + " is not a subclass of ElementView");
            }
            this.register(elementClass, elementToCursorType);
        }
        catch (ClassNotFoundException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Error registering element. Class not found: {}", (Object)binaryName);
        }
        catch (ClassCastException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Error registering element. Invalid class: {}", (Object)e.getMessage());
        }
    }

    public <T extends class_364> void register(Class<T> elementClass, ElementRegistrar.CursorTypeFunction<T> elementToCursorType) {
        this.registry.add(new ElementEntry<T>(elementClass, elementToCursorType));
    }

    public <T extends class_364> CursorType resolve(T element, double mouseX, double mouseY) {
        String elementName = element.getClass().getName();
        try {
            CursorType mapped;
            CursorProvider cursorProvider;
            CursorType providedCursorType;
            if (element instanceof CursorProvider && (providedCursorType = (cursorProvider = (CursorProvider)element).getCursorType(mouseX, mouseY)) != null && !providedCursorType.isDefault()) {
                return providedCursorType;
            }
            ElementRegistrar.CursorTypeFunction<? extends class_364> mapper = this.cache.get(elementName);
            if (mapper == null) {
                mapper = this.resolveMapper(element);
                if (!this.inspector.setProcessed(element, true)) {
                    this.cache.put(elementName, mapper);
                }
            }
            if ((mapped = mapper.getCursorType(element, mouseX, mouseY)) != null && !mapped.isDefault()) {
                return mapped;
            }
            if (element instanceof InternalCursorProvider) {
                InternalCursorProvider internalCursorProvider = (InternalCursorProvider)element;
                return internalCursorProvider.minecraft_cursor$getCursorType(mouseX, mouseY);
            }
            return CursorType.DEFAULT;
        }
        catch (Exception | LinkageError e) {
            if (!elementName.equals(this.lastFailedElement)) {
                this.lastFailedElement = elementName;
                MinecraftCursor.LOGGER.error("Could not get cursor type for element: {}", (Object)Services.PLATFORM.unmapClassName("intermediary", elementName));
            }
            return CursorType.DEFAULT;
        }
    }

    private ElementRegistrar.CursorTypeFunction<? extends class_364> resolveMapper(class_364 element) {
        for (int i = this.registry.size() - 1; i >= 0; --i) {
            if (!this.registry.get((int)i).element.isInstance(element)) continue;
            this.inspector.setProcessed(element, true);
            return this.registry.get((int)i).mapper;
        }
        if (element instanceof class_4069) {
            return this::resolveParent;
        }
        return ElementRegistrar::elementToDefault;
    }

    private CursorType resolveParent(class_4069 parent, double mouseX, double mouseY) {
        return ElementWalker.walk(parent, mouseX, mouseY, this::resolveChild, type -> !type.isDefault(), CursorType.DEFAULT);
    }

    private CursorType resolveChild(class_364 child, double mouseX, double mouseY) {
        this.inspector.setProcessed(child, false);
        return this.resolve(child, mouseX, mouseY);
    }

    public int cacheSize() {
        return this.cache.size();
    }

    public void clearCache() {
        this.cache.clear();
    }

    public ElementInspector getInspector() {
        return this.inspector;
    }

    public void toggleInspector() {
        this.inspector = ElementInspector.toggle(this.inspector);
        this.cache.clear();
    }

    record ElementEntry<T extends class_364>(Class<T> element, ElementRegistrar.CursorTypeFunction<T> mapper) {
    }
}

