/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor.resolver;

import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementInspector;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementWalker;
import io.github.fishstiz.minecraftcursor.platform.Services;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ElementInspectorImpl
implements ElementInspector {
    private static final class_2561 SCREEN_LABEL = class_2561.method_43470((String)"S: ").method_54663(-13394945);
    private static final class_2561 CACHE_LABEL = class_2561.method_43470((String)"Cache: ").method_54663(-1);
    private static final class_2561 DEEPEST_LABEL = class_2561.method_43470((String)"D: ").method_54663(-16711936);
    private static final class_2561 PROCESSED_LABEL = class_2561.method_43470((String)"P: ").method_54663(-65536);
    private static final float Z = 2000.0f;
    private static final float TEXT_SCALE = 0.75f;
    private HashSet<String> cache = new HashSet();
    private class_364 processed;
    private String processedName;
    private boolean enabled = true;

    ElementInspectorImpl() {
    }

    @Override
    public void destroy() {
        this.enabled = false;
        this.cache.clear();
        this.cache = null;
        this.processed = null;
        this.processedName = null;
    }

    @Override
    public boolean setProcessed(class_364 processed, boolean cached) {
        this.processed = processed;
        this.processedName = this.getClassName(processed);
        if (cached) {
            this.cache.add(this.processedName);
        }
        return true;
    }

    @Override
    public void render(class_310 minecraft, @NotNull class_437 screen, class_332 guiGraphics, double mouseX, double mouseY) {
        if (this.enabled) {
            class_8030 screenRectangle = this.getBounds((class_364)screen);
            this.renderScreenName(minecraft, screen, screenRectangle, guiGraphics);
            this.renderCacheSize(minecraft, screenRectangle, guiGraphics);
            this.renderProcessed(minecraft, this.renderDeepest(minecraft, screen, guiGraphics, mouseX, mouseY), guiGraphics);
        }
    }

    private class_8030 renderDeepest(class_310 minecraft, class_437 screen, class_332 guiGraphics, double mouseX, double mouseY) {
        class_364 child = ElementWalker.findDeepest((class_4069)screen, mouseX, mouseY);
        class_364 inspect = child != null ? child : screen;
        class_8030 bounds = this.getBounds(inspect);
        class_5250 label = DEEPEST_LABEL.method_27661().method_27693(this.getClassName(inspect));
        this.renderInfo(minecraft, guiGraphics, bounds, (class_2561)label, Position.TOP_LEFT, true);
        return bounds;
    }

    private void renderProcessed(class_310 minecraft, class_8030 container, class_332 guiGraphics) {
        if (this.processed != null) {
            int n;
            class_5250 label = PROCESSED_LABEL.method_27661().method_27693(this.processedName);
            class_8030 bounds = this.getBounds(this.processed);
            if (bounds.method_49618() != container.method_49618()) {
                n = 0;
            } else {
                Objects.requireNonNull(minecraft.field_1772);
                n = 9;
            }
            int offsetY = n;
            this.renderInfo(minecraft, guiGraphics, bounds, (class_2561)label, Position.TOP_LEFT, offsetY, true);
        }
    }

    private void renderScreenName(class_310 minecraft, class_437 screen, class_8030 bounds, class_332 guiGraphics) {
        class_5250 label = SCREEN_LABEL.method_27661().method_27693(this.getClassName((class_364)screen));
        this.renderInfo(minecraft, guiGraphics, bounds, (class_2561)label, Position.BOTTOM_RIGHT, false);
    }

    private void renderCacheSize(class_310 minecraft, class_8030 screenBounds, class_332 guiGraphics) {
        if (this.cache != null) {
            class_5250 label = CACHE_LABEL.method_27661().method_27693(String.valueOf(this.cache.size()));
            Objects.requireNonNull(minecraft.field_1772);
            int offsetY = -9;
            this.renderInfo(minecraft, guiGraphics, screenBounds, (class_2561)label, Position.BOTTOM_RIGHT, offsetY, false);
        }
    }

    private void renderInfo(class_310 minecraft, class_332 guiGraphics, class_8030 bounds, class_2561 label, Position pos, boolean outline) {
        this.renderInfo(minecraft, guiGraphics, bounds, label, pos, 0, outline);
    }

    private void renderInfo(class_310 minecraft, class_332 guiGraphics, class_8030 bounds, class_2561 label, Position pos, int offsetY, boolean outline) {
        class_5251 textColor = label.method_10866().method_10973();
        int color = textColor != null ? textColor.method_27716() : -1;
        int textWidth = minecraft.field_1772.method_27525((class_5348)label);
        Objects.requireNonNull(minecraft.field_1772);
        int textHeight = 9;
        int textX = pos.getX(bounds, textWidth, 0.75f, minecraft.method_22683().method_4486());
        int textY = pos.getY(bounds, offsetY, textHeight, 0.75f, minecraft.method_22683().method_4502());
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 2000.0f);
        if (outline) {
            guiGraphics.method_49601(bounds.method_49620(), bounds.method_49618(), bounds.comp_1196(), bounds.comp_1197(), 0xFF000000 | color);
        }
        poseStack.method_22905(0.75f, 0.75f, 0.0f);
        guiGraphics.method_27535(minecraft.field_1772, label, (int)((float)textX / 0.75f), (int)((float)textY / 0.75f), color);
        poseStack.method_22909();
    }

    private class_8030 getBounds(@Nullable class_364 element) {
        if (element instanceof class_8021) {
            class_8021 layoutElement = (class_8021)element;
            return layoutElement.method_48202();
        }
        return element != null ? element.method_48202() : class_8030.method_48248();
    }

    private String getClassName(class_364 element) {
        String namespace = Services.PLATFORM.isDevelopmentEnvironment() ? "named" : "intermediary";
        return Services.PLATFORM.unmapClassName(namespace, element.getClass().getName());
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

        private static final int OFFSET = 2;

        public int getX(class_8030 rect, int textWidth, float scale, int screenWidth) {
            int x;
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
                case 2: {
                    int n = rect.method_49620() + 2;
                    break;
                }
                case 1: 
                case 3: {
                    int n = x = rect.method_49620() + rect.comp_1196() - (int)((float)textWidth * scale);
                }
            }
            if ((float)x + (float)textWidth * scale > (float)screenWidth && (x = (int)((float)screenWidth - (float)textWidth * scale)) < 0) {
                x = 0;
            }
            return x;
        }

        public int getY(class_8030 rect, int offsetY, int textHeight, float scale, int screenHeight) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> rect.method_49618() + 2 + offsetY;
                case 2, 3 -> rect.comp_1197() == 0 && rect.comp_1196() == 0 ? screenHeight - (int)((float)textHeight * scale) - 2 - offsetY : rect.method_49618() - 2 + Math.max(0, rect.comp_1197() - (int)((float)textHeight * scale)) + offsetY;
            };
        }
    }
}

