/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui;

import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationState;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_332;

public class CursorAnimationHelper {
    private final Map<String, AnimationState> cursorStates = new HashMap<String, AnimationState>();

    public void reset(AnimatedCursor cursor) {
        AnimationState cursorState = this.cursorStates.get(cursor.getTypeKey());
        if (cursorState != null) {
            cursorState.reset();
        }
    }

    public void drawSprite(class_332 context, Cursor cursor, int x, int y, int size) {
        if (!cursor.isLoaded()) {
            return;
        }
        int frameIndex = 0;
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            frameIndex = this.getCurrentSpriteIndex(animatedCursor);
        }
        int cursorSize = cursor.getTextureWidth();
        int vOffset = cursorSize * frameIndex;
        context.method_25302(class_1921::method_62277, cursor.getLocation(), x, y, 0.0f, (float)vOffset, size, size, cursorSize, cursorSize, cursor.getTextureWidth(), cursor.getTextureHeight());
    }

    private int getCurrentSpriteIndex(AnimatedCursor cursor) {
        AnimationState state = this.cursorStates.computeIfAbsent(cursor.getType().getKey(), t -> new AnimationState());
        if (!cursor.isAnimated() || !cursor.isEnabled()) {
            state.reset();
            return cursor.getFallbackFrame().spriteIndex();
        }
        return cursor.getFrame(state.next(cursor)).spriteIndex();
    }
}

