/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorWidget;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorPreviewWidget
extends CursorWidget {
    private static final class_2960 BACKGROUND_128 = MinecraftCursor.loc("textures/gui/background_dark_128.png");
    private static final class_2561 PREVIEW_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.preview");
    private static final int PREVIEW_TEXT_OFFSET = 4;
    private static final int PREVIEW_TEXT_COLOR = Integer.MAX_VALUE;
    private static final int RULER_COLOR = -16711936;
    private static final int BACKGROUND_DISABLED = 0x7F000000;
    private static final int DEFAULT_BUTTON_SIZE = 20;
    @Nullable
    private final class_4185 button;
    private final class_327 font;

    public CursorPreviewWidget(@NotNull Cursor cursor, @NotNull class_327 font, @Nullable class_4185 button) {
        super(class_5244.field_39003, cursor, BACKGROUND_128);
        this.field_22763 = false;
        this.font = font;
        this.button = button;
    }

    public CursorPreviewWidget(@NotNull Cursor cursor, @NotNull class_327 font) {
        this(cursor, font, class_4185.method_46430((class_2561)class_5244.field_39003, b -> b.method_25365(false)).method_46437(20, 20).method_46431());
    }

    @Override
    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        Cursor cursor = this.getCursor();
        if (cursor.isLoaded()) {
            this.renderBackground(guiGraphics);
            if (cursor.isEnabled()) {
                this.renderPreviewText(guiGraphics);
                this.renderButton(guiGraphics, mouseX, mouseY, partialTick);
                this.renderRuler(guiGraphics, mouseX, mouseY);
            }
        }
        if (!cursor.isEnabled()) {
            guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), 0x7F000000);
        }
        this.renderBorder(guiGraphics);
    }

    protected void renderPreviewText(@NotNull class_332 guiGraphics) {
        int width = this.font.method_27525((class_5348)PREVIEW_TEXT);
        int endX = this.method_55442() - 4;
        int endY = this.method_55443() - 4;
        int startX = endX - width;
        Objects.requireNonNull(this.font);
        int startY = endY - 9;
        DrawUtil.drawScrollableTextLeftAlign(guiGraphics, this.font, PREVIEW_TEXT, startX, startY, endX, endY, Integer.MAX_VALUE, false);
        guiGraphics.method_51452();
    }

    protected void renderButton(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.button != null) {
            int buttonX = this.method_46426() + (this.method_25368() / 2 - this.button.method_25368() / 2);
            int buttonY = this.method_46427() + (this.method_25364() / 2 - this.button.method_25364() / 2);
            this.button.method_48229(buttonX, buttonY);
            this.button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected void renderRuler(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            guiGraphics.method_25292(this.method_46426(), this.method_55442() - 1, mouseY, -16711936);
            guiGraphics.method_25301(mouseX, this.method_46427(), this.method_55443(), -16711936);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.button != null && this.button.method_25405(mouseX, mouseY)) {
            this.button.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.method_46426() && mouseY >= (double)this.method_46427() && mouseX < (double)this.method_55442() && mouseY < (double)this.method_55443();
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        return this.getCursor().getType();
    }
}

