/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.gui.widget.ElementView;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementSlidingBackground {
    private final boolean outlineOnly;
    private final int color;
    private float lastY = 0.0f;

    public ElementSlidingBackground(int color, boolean outlineOnly) {
        this.color = color;
        this.outlineOnly = outlineOnly;
    }

    public ElementSlidingBackground(int color) {
        this(color, false);
    }

    public void reset() {
        this.lastY = 0.0f;
    }

    public void render(@NotNull class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        this.lastY = this.lastY == 0.0f ? (float)y : this.lastY;
        this.lastY = Math.abs(this.lastY - (float)y) < 0.5f ? (float)y : class_3532.method_16439((float)partialTick, (float)this.lastY, (float)y);
        int right = x + width;
        int bottom = (int)this.lastY + height;
        if (this.outlineOnly) {
            guiGraphics.method_49601(x, (int)this.lastY, width, height, this.color);
        } else {
            guiGraphics.method_25294(x, (int)this.lastY, right, bottom, this.color);
        }
    }

    public void render(@NotNull class_332 guiGraphics, @Nullable ElementView element, float partialTick) {
        if (element == null) {
            this.reset();
            return;
        }
        this.render(guiGraphics, element.getX(), element.getY(), element.getWidth(), element.getHeight(), partialTick);
    }
}

