/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CatalogItem;
import io.github.fishstiz.minecraftcursor.gui.widget.AbstractListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ElementSlidingBackground;
import io.github.fishstiz.minecraftcursor.gui.widget.ElementView;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.TabOrderedElement;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CatalogBrowserScreen
extends Screen {
    private static final Component SEARCH_TEXT = Component.translatable((String)"minecraft-cursor.options.search");
    private static final Tooltip CLEAR_SEARCH_INFO = Tooltip.create((Component)Component.translatable((String)"minecraft-cursor.options.search.clear"));
    private static final Tooltip REFRESH_INFO = Tooltip.create((Component)Component.translatable((String)"minecraft-cursor.options.refresh.info"));
    private static final ResourceLocation EXIT_SPRITE = MinecraftCursor.loc("textures/gui/sprites/icon/caret_right.png");
    private static final ResourceLocation CLEAR_SPRITE = MinecraftCursor.loc("textures/gui/sprites/icon/cross.png");
    private static final ResourceLocation REFRESH_SPRITE = MinecraftCursor.loc("textures/gui/sprites/icon/arrow_clockwise.png");
    private final Screen previous;
    private final int headerHeight;
    private final int sidebarWidth;
    private final int maxContentWidth;
    private final int spacing;
    private final Map<CatalogItem, ItemContext> items = new LinkedHashMap<CatalogItem, ItemContext>();
    private EditBox searchField;
    private ButtonWidget clearButton;
    private ItemList catalog;
    private ButtonWidget doneButton;
    private ButtonWidget refreshButton;
    private ContentPanel contents;
    private String previousSearch = "";

    protected CatalogBrowserScreen(Component title, int headerHeight, int sidebarWidth, int maxContentWidth, int spacing, Screen previous) {
        super(title);
        this.headerHeight = headerHeight;
        this.sidebarWidth = sidebarWidth;
        this.maxContentWidth = maxContentWidth;
        this.spacing = spacing;
        this.previous = previous;
    }

    protected void initItems() {
    }

    protected void postInit() {
    }

    protected final void init() {
        this.doneButton = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(CommonComponents.GUI_DONE, this::onClose).withSize(20).withTooltip(CommonComponents.GUI_DONE).spriteOnly(EXIT_SPRITE));
        this.clearButton = new ButtonWidget(CommonComponents.EMPTY, this::clearSearch).withSize(20).withTooltip(CLEAR_SEARCH_INFO).spriteOnly(CLEAR_SPRITE);
        this.clearButton.active = false;
        this.searchField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.sidebarWidth - this.clearButton.getWidth() - this.spacing, this.headerHeight, SEARCH_TEXT));
        this.searchField.setHint(SEARCH_TEXT);
        this.searchField.setResponder(this::search);
        this.addRenderableWidget((GuiEventListener)this.clearButton);
        this.catalog = (ItemList)this.addRenderableWidget((GuiEventListener)new ItemList(this.minecraft, this.font, this.sidebarWidth, this.spacing, this::onItemChange));
        this.refreshButton = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(CommonComponents.EMPTY, this::refreshItemsAndPanel).withSize(20).withTooltip(REFRESH_INFO).spriteOnly(REFRESH_SPRITE));
        this.initItems();
        this.refreshItems();
        this.repositionElements();
        this.postInit();
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.previous);
        }
    }

    public void removed() {
        if (this.contents != null) {
            this.contents.removed();
        }
    }

    protected final void repositionElements() {
        int contentsWidth = this.getContentWidth();
        int usableWidth = this.sidebarWidth + this.spacing + contentsWidth;
        int maxOffsetX = this.width - usableWidth - this.spacing;
        int leftColumnX = Math.max(this.spacing, Math.min((this.width - usableWidth) / 2, maxOffsetX));
        int rightColumnX = leftColumnX + this.sidebarWidth + this.spacing;
        if (this.doneButton != null && this.refreshButton != null) {
            this.doneButton.setPosition(rightColumnX + contentsWidth - this.doneButton.getWidth(), this.spacing);
            this.refreshButton.setPosition(this.doneButton.getX() - this.refreshButton.getWidth() - this.spacing, this.spacing);
        }
        if (this.searchField != null && this.clearButton != null) {
            this.searchField.setPosition(leftColumnX, this.spacing);
            this.clearButton.setPosition(this.searchField.getRight() + this.spacing, this.spacing);
        }
        if (this.catalog != null) {
            this.catalog.setHeight(this.height - this.spacing * 2 - (this.headerHeight + this.spacing));
            this.catalog.setPosition(leftColumnX, this.spacing + this.headerHeight + this.spacing);
            this.catalog.clampScrollAmount();
        }
        if (this.contents != null) {
            this.contents.setWidth(contentsWidth);
            this.contents.setHeight(this.height - this.spacing * 2);
            this.contents.setPosition(rightColumnX, this.spacing);
            this.contents.repositionElements();
        }
    }

    protected int getContentWidth() {
        int totalWidth = this.width - this.spacing * 2;
        return this.maxContentWidth <= 0 ? totalWidth - this.sidebarWidth - this.spacing : Math.min(this.maxContentWidth, totalWidth - this.sidebarWidth - this.spacing);
    }

    protected void selectItem(@Nullable CatalogItem item) {
        if (item != null) {
            this.catalog.select(item);
        } else {
            this.catalog.select((CatalogItem)null);
            if (this.contents != null) {
                this.removeWidget(this.contents);
                this.contents.removed();
                this.contents = null;
            }
        }
    }

    private void onItemChange(CatalogItem item) {
        ItemContext itemContext = this.items.get(item);
        if (itemContext == null) {
            throw new NullPointerException("CatalogItem " + item.id() + " context not found.");
        }
        ContentPanel contentPanel = itemContext.contents();
        if (contentPanel != this.contents) {
            if (this.contents != null) {
                this.removeWidget(this.contents);
                this.contents.removed();
            }
            this.contents = contentPanel;
            this.contents.changedItem(this.previousSearch, itemContext.category(), item);
            this.addRenderableWidget(this.contents);
            this.contents.added(this.previousSearch);
        } else {
            this.contents.changedItem(this.previousSearch, itemContext.category(), item);
        }
        this.repositionElements();
    }

    protected CatalogItem addCategory(@NotNull CatalogItem category, boolean collapsible, boolean collapsed) {
        this.catalog.addCategory(Objects.requireNonNull(category), new CategoryContext(collapsible, collapsed));
        return category;
    }

    protected CatalogItem addCategory(@NotNull CatalogItem category) {
        return this.addCategory(category, true, false);
    }

    protected void addCategoryOnly(@NotNull CatalogItem category, @NotNull ContentPanel panel) {
        this.addCategory(category, false, true);
        this.items.put(category, new ItemContext(category, this.initPanel(panel)));
    }

    protected void addItem(@NotNull CatalogItem category, @NotNull CatalogItem item, @NotNull ContentPanel panel) {
        if (this.items.containsKey(Objects.requireNonNull(category))) {
            throw new IllegalStateException("Category " + category.id() + " is already an item.");
        }
        this.items.put(Objects.requireNonNull(item), new ItemContext(category, this.initPanel(panel)));
        this.catalog.addItem(category, item);
    }

    protected void updateItem(@NotNull CatalogItem item, @NotNull ContentPanel contentPanel) {
        ItemContext oldContext = this.items.get(item);
        if (oldContext == null) {
            throw new IllegalStateException("CatalogItem " + item.id() + " has not beed added.");
        }
        ItemContext context = Objects.requireNonNull(this.items.computeIfPresent(item, (i, ctx) -> new ItemContext(ctx.category(), this.initPanel(contentPanel))));
        this.items.replace(item, context);
        this.catalog.replaceItem(context.category(), item);
        if (this.contents != null && this.contents == oldContext.contents() && item.equals(this.contents.getItem())) {
            if (oldContext.contents() != context.contents()) {
                boolean isFocused = this.getFocused() == this.contents;
                this.removeWidget(this.contents);
                this.contents.removed();
                this.contents = context.contents();
                if (isFocused) {
                    this.setFocused(this.contents);
                }
                this.contents.changedItem(this.previousSearch, context.category(), item);
                this.addRenderableWidget(this.contents);
                this.contents.added(this.previousSearch);
            } else {
                this.contents.changedItem(this.previousSearch, context.category(), item);
            }
            this.repositionElements();
        }
    }

    protected void addOrUpdateItem(@NotNull CatalogItem category, @NotNull CatalogItem item, @NotNull ContentPanel panel) {
        if (this.items.containsKey(item)) {
            this.updateItem(item, panel);
        } else {
            this.addItem(category, item, panel);
        }
    }

    protected void refreshItems() {
        this.catalog.refreshEntries();
    }

    protected void refreshItemsAndPanel() {
        this.refreshItems();
        if (this.contents != null) {
            this.contents.removed();
            this.contents.added();
        }
        this.repositionElements();
    }

    protected Button getRefreshButton() {
        return this.refreshButton;
    }

    private ContentPanel initPanel(ContentPanel panel) {
        panel.init(this.minecraft, this.font, this, this.headerHeight, this.getContentWidth() - this.doneButton.getWidth() - this.refreshButton.getWidth() - this.spacing * 2, this.spacing);
        return panel;
    }

    protected void focusPath(GuiEventListener child) {
        this.clearFocus();
        ComponentPath.path((GuiEventListener)child, (ContainerEventHandler[])new ContainerEventHandler[]{this}).applyFocus(true);
    }

    protected boolean autoFocusSearch() {
        return true;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (super.charTyped(codePoint, modifiers)) {
            return true;
        }
        if (this.autoFocusSearch() && codePoint != ' ' && this.searchField != null && !this.searchField.isFocused()) {
            this.focusPath((GuiEventListener)this.searchField);
            return this.searchField.charTyped(codePoint, modifiers);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.autoFocusSearch() && keyCode == 259 && this.searchField != null && !this.searchField.isFocused() && !this.searchField.getValue().isEmpty()) {
            this.focusPath((GuiEventListener)this.searchField);
            return this.searchField.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private void clearSearch() {
        if (this.searchField != null) {
            this.searchField.setValue("");
        }
    }

    private void search(String search) {
        if (this.clearButton != null) {
            boolean bl = this.clearButton.active = !search.isEmpty();
        }
        if (Objects.equals(this.previousSearch, search)) {
            return;
        }
        this.previousSearch = search;
        if (search.isEmpty()) {
            this.catalog.filterItems(null);
            this.refreshItems();
            if (this.contents != null) {
                this.contents.searched(search, null);
            }
        } else {
            SearchResult result = this.performSearch(search.toLowerCase());
            this.catalog.filterItems(result.visibleItems());
            if (result.firstResult() != null) {
                this.selectItem(result.firstResult());
            }
            this.refreshItems();
            if (this.contents != null) {
                this.contents.searched(search, result.firstMatch());
            }
        }
    }

    private SearchResult performSearch(String lowercaseSearch) {
        HashMap<CatalogItem, Set<CatalogItem>> visibleItems = new HashMap<CatalogItem, Set<CatalogItem>>();
        CatalogItem firstResult = null;
        Component firstMatch = null;
        for (Map.Entry<CatalogItem, ItemContext> itemEntry : this.items.entrySet()) {
            ItemContext context;
            CatalogItem item = itemEntry.getKey();
            MatchResult matchResult = this.findMatch(item, context = itemEntry.getValue(), lowercaseSearch);
            if (!matchResult.hasMatch()) continue;
            if (firstResult == null) {
                firstResult = item;
                firstMatch = matchResult.matchedText();
            }
            visibleItems.computeIfAbsent(context.category(), k -> new HashSet()).add(item);
        }
        return new SearchResult(visibleItems, firstResult, firstMatch);
    }

    private MatchResult findMatch(CatalogItem item, ItemContext context, String lowercaseSearch) {
        Component matchedText = CatalogBrowserScreen.containsStringLowerCase(context.contents().indexed, lowercaseSearch);
        if (matchedText != null) {
            return new MatchResult(true, matchedText);
        }
        if (CatalogBrowserScreen.containsStringLowerCase(item.text(), lowercaseSearch)) {
            return new MatchResult(true, null);
        }
        if (CatalogBrowserScreen.containsStringLowerCase(context.category().text(), lowercaseSearch)) {
            return new MatchResult(true, null);
        }
        return new MatchResult(false, null);
    }

    private static boolean containsStringLowerCase(Component text, String string) {
        return text.plainCopy().getString().toLowerCase().contains(string);
    }

    @Nullable
    private static Component containsStringLowerCase(List<Component> texts, String string) {
        for (Component text : texts) {
            if (!CatalogBrowserScreen.containsStringLowerCase(text, string)) continue;
            return text;
        }
        return null;
    }

    private static class ItemList
    extends AbstractListWidget<AbstractItemEntry> {
        private static final int UNPADDED_HEIGHT = 8;
        private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF);
        private final ElementSlidingBackground selectedBackground = new ElementSlidingBackground(0x33FFFFFF);
        private final ElementSlidingBackground focusedBackground = new ElementSlidingBackground(-1, true);
        private final Map<CatalogItem, CategoryContext> categories = new LinkedHashMap<CatalogItem, CategoryContext>();
        private final Map<CatalogItem, Set<CatalogItem>> visibleItems = new HashMap<CatalogItem, Set<CatalogItem>>();
        private final Consumer<CatalogItem> onSelect;
        private final Font font;
        private final int spacing;
        private boolean searching;
        @Nullable
        private CatalogItem selectedItem;

        private ItemList(Minecraft minecraft, Font font, int width, int spacing, Consumer<CatalogItem> onSelect) {
            super(minecraft, width, 0, 0, 8 + spacing * 2);
            this.onSelect = onSelect;
            this.font = font;
            this.spacing = spacing;
        }

        private void addCategory(CatalogItem category, CategoryContext context) {
            this.categories.put(category, context);
        }

        private void addItem(CatalogItem category, CatalogItem item) {
            CategoryContext context = this.categories.computeIfAbsent(category, c -> new CategoryContext());
            context.items().add(item);
        }

        private void replaceItem(@NotNull CatalogItem category, @NotNull CatalogItem item) {
            int index = this.indexOf(category, item);
            if (index == -1) {
                throw new IllegalStateException("CatalogItem " + item.id() + " has not beed added.");
            }
            this.categories.get(category).items().set(index, item);
        }

        private int indexOf(@NotNull CatalogItem category, @Nullable CatalogItem item) {
            CategoryContext context = this.categories.get(category);
            if (context != null) {
                List<CatalogItem> items = context.items();
                for (int i = 0; i < items.size(); ++i) {
                    if (!Objects.equals(items.get(i), item)) continue;
                    return i;
                }
            }
            return -1;
        }

        private void filterItems(@Nullable Map<CatalogItem, Set<CatalogItem>> visibleItems) {
            this.visibleItems.clear();
            boolean bl = this.searching = visibleItems != null;
            if (this.searching) {
                this.visibleItems.putAll(visibleItems);
            }
        }

        private void refreshEntries() {
            AbstractItemEntry focusedEntry = (AbstractItemEntry)this.getFocused();
            AbstractItemEntry selectedEntry = (AbstractItemEntry)this.getSelected();
            this.clearEntries();
            this.setFocused(null);
            for (Map.Entry<CatalogItem, CategoryContext> categoryContexts : this.categories.entrySet()) {
                if (this.searching && !this.visibleItems.containsKey(categoryContexts.getKey())) continue;
                CategoryContext categoryContext = categoryContexts.getValue();
                CatalogItem categoryItem = categoryContexts.getKey().withText(text -> text.copy().withStyle(style -> style.withBold(Boolean.valueOf(true)))).withPrefix(CategoryEntry.applyCollapsibleSymbol(categoryContext));
                CategoryEntry categoryEntry = new CategoryEntry(this, this.font, categoryItem, categoryContext.collapsible(), this.spacing);
                this.addEntry((AbstractSelectionList.Entry)categoryEntry);
                if (categoryContext.collapsed()) continue;
                Set<CatalogItem> items = this.visibleItems.get(categoryItem);
                for (CatalogItem item : categoryContexts.getValue().items()) {
                    if (this.searching && (items == null || !items.isEmpty() && !items.contains(item))) continue;
                    ItemEntry selectableEntry = new ItemEntry(this, this.font, item, this.spacing);
                    this.addEntry((AbstractSelectionList.Entry)selectableEntry);
                }
            }
            this.setFocused(focusedEntry);
            if (focusedEntry != selectedEntry) {
                this.setSelected(selectedEntry);
            }
            this.clampScrollAmount();
        }

        private void select(CatalogItem item, @Nullable AbstractItemEntry itemEntry) {
            if (this.selectedItem == null || !this.selectedItem.equals(item)) {
                this.selectedItem = item;
                this.setFocused(itemEntry);
                if (itemEntry != null) {
                    this.ensureVisible((AbstractSelectionList.Entry)itemEntry);
                }
                this.onSelect.accept(this.selectedItem);
            }
        }

        private void select(AbstractItemEntry itemEntry) {
            this.select(itemEntry.getItem(), itemEntry);
        }

        private void select(@Nullable CatalogItem item) {
            if (item != null) {
                this.select(item, this.getEntryFromItem(item));
            } else {
                this.selectedItem = null;
            }
        }

        private void toggleCategory(AbstractItemEntry itemEntry) {
            if (!(itemEntry instanceof CategoryEntry)) {
                throw new IllegalArgumentException("Entry is not an instance of CategoryEntry");
            }
            CategoryEntry categoryEntry = (CategoryEntry)itemEntry;
            CatalogItem category = categoryEntry.getItem();
            CategoryContext context = this.categories.computeIfPresent(category, (c, ctx) -> ctx.toggle());
            this.setFocused(categoryEntry);
            this.refreshEntries();
            AbstractItemEntry focused = (AbstractItemEntry)this.getFocused();
            if (focused != null) {
                focused.setFocused((GuiEventListener)focused.button);
            }
            if (context != null && !context.collapsed() && this.indexOf(category, this.selectedItem) == -1) {
                this.select(context.items().getFirst());
            }
        }

        @Nullable
        private AbstractItemEntry getEntryFromItem(@Nullable CatalogItem item) {
            if (item != null) {
                for (AbstractItemEntry entry : this.children()) {
                    if (!entry.getItem().equals(item)) continue;
                    return entry;
                }
            }
            return null;
        }

        private void renderSlidingBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoveredBackground.render(guiGraphics, (ElementView)this.getEntryAtPosition(mouseX, mouseY), partialTick);
            this.selectedBackground.render(guiGraphics, this.getEntryFromItem(this.selectedItem), partialTick);
            this.focusedBackground.render(guiGraphics, (ElementView)this.getFocused(), partialTick);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            this.selectedBackground.reset();
            this.focusedBackground.reset();
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public void renderListItems(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderSlidingBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.renderListItems(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void setFocused(@Nullable GuiEventListener focused) {
            if (focused instanceof AbstractItemEntry) {
                AbstractItemEntry itemEntry = (AbstractItemEntry)focused;
                focused = this.getEntryFromItem(itemEntry.getItem());
            }
            super.setFocused(focused);
        }

        public void setSelected(@Nullable AbstractItemEntry selected) {
            if (selected != null) {
                selected = this.getEntryFromItem(selected.getItem());
            }
            super.setSelected((AbstractSelectionList.Entry)selected);
        }

        private abstract class AbstractItemEntry
        extends AbstractListWidget.Entry
        implements ElementView {
            protected final Font font;
            protected final CatalogItem item;
            protected final ItemButton button;
            protected final List<ItemButton> children;

            protected AbstractItemEntry(ItemList itemList, Font font, CatalogItem item, int spacing, Consumer<AbstractItemEntry> onClick) {
                super(itemList);
                this.font = font;
                this.item = item;
                this.button = new ItemButton(this.item, this.font, spacing, itemButton -> onClick.accept(this));
                this.children = Collections.singletonList(this.button);
            }

            CatalogItem getItem() {
                return this.item;
            }

            public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                this.button.setSize(this.getWidth(), this.getHeight());
                this.button.setPosition(this.getX(), this.getY());
                this.button.render(guiGraphics, mouseX, mouseY, partialTick);
            }

            public void setFocused(boolean focused) {
                super.setFocused(focused);
                GuiEventListener focusedElement = this.getFocused();
                if (focusedElement != null) {
                    focusedElement.setFocused(focused);
                }
            }

            @NotNull
            public List<ItemButton> children() {
                return this.children;
            }

            @NotNull
            public List<ItemButton> narratables() {
                return this.children;
            }
        }

        private class CategoryEntry
        extends AbstractItemEntry {
            private static final Component COLLAPSED_SYMBOL = CategoryEntry.wrapSymbol("\u25b6");
            private static final Component COLLAPSIBLE_SYMBOL = CategoryEntry.wrapSymbol("\u25bc");
            private static final Component NON_COLLAPSIBLE_SYMBOL = CategoryEntry.wrapSymbol("\u25a0");
            private static final int SYMBOL_COLOR = -1;

            private CategoryEntry(ItemList itemList, Font font, CatalogItem item, boolean collapsible, int spacing) {
                super(itemList, font, item, spacing, collapsible ? itemList::toggleCategory : itemList::select);
            }

            private static Component wrapSymbol(String symbol) {
                return Component.literal((String)symbol).withStyle(style -> style.withBold(Boolean.valueOf(true)));
            }

            private static UnaryOperator<CatalogItem.Prefix> applyCollapsibleSymbol(CategoryContext context) {
                Component symbol = !context.collapsible() ? NON_COLLAPSIBLE_SYMBOL : (context.collapsed() ? COLLAPSED_SYMBOL : COLLAPSIBLE_SYMBOL);
                return prefix -> {
                    if (prefix != null) {
                        return prefix;
                    }
                    return (guiGraphics, font, item, bounds, spacing, mouseX, mouseY, partialTick) -> {
                        int x = bounds.getX() + spacing;
                        int n = bounds.getY();
                        int n2 = bounds.getHeight();
                        Objects.requireNonNull(font);
                        int y = n + (n2 - 9) / 2;
                        int width = Math.max(font.width((FormattedText)NON_COLLAPSIBLE_SYMBOL), Math.max(font.width((FormattedText)COLLAPSED_SYMBOL), font.width((FormattedText)COLLAPSIBLE_SYMBOL)));
                        int endX = x + width;
                        Objects.requireNonNull(font);
                        int endY = y + 9;
                        DrawUtil.drawScrollableTextLeftAlign(guiGraphics, font, symbol, x, y, endX, endY, -1);
                        return width;
                    };
                };
            }
        }

        private class ItemEntry
        extends AbstractItemEntry {
            private ItemEntry(ItemList itemList, Font font, CatalogItem item, int spacing) {
                super(itemList, font, item, spacing, itemList::select);
            }
        }
    }

    public static abstract class ContentPanel
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry,
    ElementView {
        private final List<Component> indexed = new ArrayList<Component>();
        private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
        private final List<Renderable> renderables = new ArrayList<Renderable>();
        private final List<NarratableEntry> narratables = new ArrayList<NarratableEntry>();
        private int x;
        private int y;
        private int width;
        private int height;
        private NarratableEntry lastNarratable;
        private CatalogItem item;
        private CatalogItem category;
        private boolean initialized;
        private int spacing;
        private int headerHeight;
        private int headerWidth;
        private Minecraft minecraft;
        private Font font;
        private CatalogBrowserScreen catalog;
        @NotNull
        private String search = "";

        protected void added() {
        }

        protected void removed() {
        }

        protected void changed(@NotNull CatalogItem category, @NotNull CatalogItem item) {
        }

        protected void searched(@NotNull String search, @Nullable Component matched) {
        }

        protected void repositionElements() {
        }

        protected abstract void init();

        private void init(Minecraft minecraft, Font font, CatalogBrowserScreen catalog, int headerHeight, int headerWidth, int spacing) {
            if (!this.initialized) {
                this.initialized = true;
                this.minecraft = minecraft;
                this.font = font;
                this.catalog = catalog;
                this.spacing = spacing;
                this.headerHeight = headerHeight;
                this.headerWidth = headerWidth;
                this.init();
            }
        }

        private void added(@NotNull String search) {
            this.search = search;
            this.added();
        }

        private void changedItem(@NotNull String search, @NotNull CatalogItem category, @NotNull CatalogItem item) {
            this.category = Objects.requireNonNull(category);
            this.item = Objects.requireNonNull(item);
            this.search = search;
            this.changed(this.category, this.item);
        }

        protected void clearWidgets() {
            this.indexed.clear();
            this.children.clear();
            this.renderables.clear();
            this.narratables.clear();
        }

        protected Component index(Component text) {
            this.indexed.add(text);
            return text;
        }

        protected <T extends Renderable & GuiEventListener> void addRenderableWidget(T widget) {
            this.children.add(widget);
            this.narratables.add((NarratableEntry)widget);
            this.renderables.add(widget);
        }

        protected void addRenderableIndexedWidget(AbstractWidget widget) {
            this.addRenderableWidget(widget);
            this.indexed.add(widget.getMessage());
        }

        protected final void changeItem(CatalogItem item) {
            this.catalog.selectItem(item);
        }

        protected CatalogBrowserScreen getScreen() {
            return this.catalog;
        }

        protected Minecraft getMinecraft() {
            return this.minecraft;
        }

        protected Font getFont() {
            return this.font;
        }

        public CatalogItem getItem() {
            return this.item;
        }

        public CatalogItem getCategory() {
            return this.category;
        }

        @NotNull
        public String getSearch() {
            return this.search;
        }

        public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            for (Renderable renderable : this.renderables) {
                renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.getWidth()) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.getHeight());
        }

        @NotNull
        public List<GuiEventListener> children() {
            return this.children;
        }

        private void setPosition(int x, int y) {
            this.setX(x);
            this.setY(y);
        }

        private void setX(int x) {
            this.x = x;
        }

        private void setY(int y) {
            this.y = y;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        private void setWidth(int width) {
            this.width = width;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        private void setHeight(int height) {
            this.height = height;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public int getSpacing() {
            return this.spacing;
        }

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public int getHeaderWidth() {
            return this.headerWidth;
        }

        @NotNull
        public final NarratableEntry.NarrationPriority narrationPriority() {
            return this.isFocused() ? NarratableEntry.NarrationPriority.FOCUSED : NarratableEntry.NarrationPriority.NONE;
        }

        public final void updateNarration(@NotNull NarrationElementOutput narrationElementOutput) {
            List<NarratableEntry> sortedNarratables = this.narratables.stream().filter(NarratableEntry::isActive).sorted(Comparator.comparingInt(TabOrderedElement::getTabOrderGroup)).toList();
            Screen.NarratableSearchResult narratableSearchResult = Screen.findNarratableWidget(sortedNarratables, (NarratableEntry)this.lastNarratable);
            if (narratableSearchResult != null) {
                if (narratableSearchResult.priority.isTerminal()) {
                    this.lastNarratable = narratableSearchResult.entry;
                }
                if (sortedNarratables.size() > 1 && narratableSearchResult.priority == NarratableEntry.NarrationPriority.FOCUSED) {
                    narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.component_list.usage"));
                }
                narratableSearchResult.entry.updateNarration(narrationElementOutput.nest());
            }
        }
    }

    private record ItemContext(@NotNull CatalogItem category, @NotNull ContentPanel contents) {
        private ItemContext(@NotNull CatalogItem category, @NotNull ContentPanel contents) {
            Objects.requireNonNull(category);
            Objects.requireNonNull(contents);
        }
    }

    private record CategoryContext(boolean collapsible, boolean collapsed, @NotNull List<CatalogItem> items) {
        private CategoryContext(boolean collapsible, boolean collapsed, @NotNull List<CatalogItem> items) {
            Objects.requireNonNull(items);
        }

        public CategoryContext(boolean collapsible, boolean collapsed) {
            this(collapsible, collapsed, new ArrayList<CatalogItem>());
        }

        public CategoryContext() {
            this(true, false, new ArrayList<CatalogItem>());
        }

        private CategoryContext toggle() {
            if (!this.collapsible) {
                throw new IllegalStateException("Cannot collapse non-collapsible category");
            }
            return new CategoryContext(true, !this.collapsed, this.items);
        }
    }

    private record SearchResult(Map<CatalogItem, Set<CatalogItem>> visibleItems, @Nullable CatalogItem firstResult, @Nullable Component firstMatch) {
    }

    private record MatchResult(boolean hasMatch, Component matchedText) {
    }

    private static class ItemButton
    extends AbstractButton {
        private static final int TEXT_COLOR = -1;
        private final Consumer<ItemButton> onClick;
        private final CatalogItem item;
        private final Font font;
        private final int spacing;

        public ItemButton(CatalogItem item, Font font, int spacing, Consumer<ItemButton> onClick) {
            super(0, 0, 0, 0, item.text());
            this.font = font;
            this.item = item;
            this.spacing = spacing;
            this.onClick = Objects.requireNonNull(onClick);
        }

        public void onPress() {
            this.onClick.accept(this);
        }

        protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int prefixWidth;
            int n = prefixWidth = this.item.prefix() != null ? this.item.prefix().render(guiGraphics, this.font, this.item, (LayoutElement)this, this.spacing, mouseX, mouseY, partialTick) : 0;
            if (prefixWidth > 0) {
                prefixWidth += this.spacing;
            }
            int startX = this.getX() + this.spacing + prefixWidth;
            int n2 = this.getY();
            int n3 = this.getHeight();
            Objects.requireNonNull(this.font);
            int startY = n2 + (n3 - 9) / 2;
            int endX = this.getRight() - this.spacing;
            Objects.requireNonNull(this.font);
            int endY = startY + 9;
            DrawUtil.drawScrollableTextLeftAlign(guiGraphics, this.font, this.getMessage(), startX, startY, endX, endY, -1);
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.add(NarratedElementType.TITLE, this.getMessage());
        }
    }
}

