/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class CursorWidget
extends AbstractWidget
implements CursorProvider {
    public static final int DEFAULT_HEIGHT = 32;
    public static final int DEFAULT_WIDTH = 32;
    private static final int BACKGROUND_SIZE = 128;
    private static final int BORDER_COLOR = -16777216;
    private static final int FOCUSED_BORDER_COLOR = -1;
    private final ResourceLocation background128;
    private final Cursor cursor;

    protected CursorWidget(int x, int y, int width, int height, @NotNull Component message, @NotNull Cursor cursor, @NotNull ResourceLocation background128) {
        super(x, y, width, height, message);
        this.cursor = cursor;
        this.background128 = background128;
    }

    protected CursorWidget(@NotNull Component message, @NotNull Cursor cursor, @NotNull ResourceLocation background128) {
        this(0, 0, 32, 32, message, cursor, background128);
    }

    protected void renderCursor(@NotNull GuiGraphics guiGraphics, @NotNull Cursor cursor) {
    }

    protected abstract void renderRuler(@NotNull GuiGraphics var1, int var2, int var3);

    protected void renderBackground(@NotNull GuiGraphics guiGraphics) {
        DrawUtil.drawCheckerboard(guiGraphics, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getCellSize(), this.background128, 128);
    }

    protected void renderBorder(@NotNull GuiGraphics guiGraphics) {
        int color = this.isFocused() && this.active ? -1 : -16777216;
        guiGraphics.renderOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), color);
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.cursor.isLoaded()) {
            this.renderBackground(guiGraphics);
            this.renderCursor(guiGraphics, this.cursor);
            this.renderRuler(guiGraphics, mouseX, mouseY);
        }
        this.renderBorder(guiGraphics);
    }

    @NotNull
    protected Cursor getCursor() {
        return this.cursor;
    }

    protected float getCellSize() {
        Cursor currentCursor = this.getCursor();
        return currentCursor.isLoaded() ? (float)this.getWidth() / (float)this.getCursor().getTextureWidth() : 0.0f;
    }

    public int getRight() {
        return this.getX() + this.getWidth();
    }

    public int getBottom() {
        return this.getY() + this.getHeight();
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }
}

