/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.gui.widget.AbstractListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ElementSlidingBackground;
import io.github.fishstiz.minecraftcursor.gui.widget.SliderWidget;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsListWidget
extends AbstractListWidget<AbstractEntry> {
    private static final int BACKGROUND_PADDING_Y = 2;
    private static final int SEARCH_HIGHLIGHT_COLOR = 1728042752;
    private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF);
    private final class_327 font;
    @NotNull
    private String search = "";

    public OptionsListWidget(class_310 minecraft, class_327 font, int itemHeight, int spacing) {
        super(minecraft, 0, 0, 0, itemHeight, spacing);
        this.font = font;
    }

    public OptionsListWidget(class_310 minecraft, class_327 font, int spacing) {
        this(minecraft, font, 20, spacing);
    }

    public void addWidget(class_339 widget) {
        this.method_25321((class_350.class_351)new WidgetEntry(widget));
    }

    public void addToggle(boolean value, @NotNull Consumer<Boolean> onToggle, @NotNull class_2561 label, @Nullable class_7919 tooltip, boolean active) {
        this.method_25321((class_350.class_351)new ToggleEntry(value, onToggle, label, null, tooltip, active));
    }

    public void addToggle(boolean value, @NotNull Consumer<Boolean> onToggle, @NotNull class_2561 label, @Nullable Prefix prefix, @Nullable class_7919 tooltip, boolean active) {
        this.method_25321((class_350.class_351)new ToggleEntry(value, onToggle, label, prefix, tooltip, active));
    }

    public void addToggleableSlider(@NotNull SliderWidget slider, boolean value, @NotNull Consumer<Boolean> onToggle, @Nullable class_7919 tooltip) {
        this.method_25321((class_350.class_351)new ToggleableSliderEntry(slider, value, onToggle, tooltip, true));
    }

    public void search(@NotNull String search) {
        this.search = search.toLowerCase();
        if (!this.search.isEmpty()) {
            for (AbstractEntry entry : this.method_25396()) {
                if (!entry.indexedLabel.contains(this.search)) continue;
                this.method_25328((class_350.class_351)entry);
                break;
            }
        }
    }

    private int computeBackgroundX(AbstractEntry entry) {
        return entry.getX() - this.rowGap;
    }

    private int computeBackgroundY(AbstractEntry entry) {
        return entry.getY() - 2;
    }

    private int computeBackgroundWidth(AbstractEntry entry) {
        return entry.getWidth() + this.rowGap + (this.method_57717() ? 6 : 2);
    }

    private int computeBackgroundHeight(AbstractEntry entry) {
        return entry.getHeight() + 4;
    }

    protected void renderSearchBackground(@NotNull class_332 guiGraphics) {
        if (!this.search.isEmpty()) {
            for (AbstractEntry entry : this.method_25396()) {
                if (!entry.indexedLabel.contains(this.search)) continue;
                int bgX = this.computeBackgroundX(entry);
                int bgY = this.computeBackgroundY(entry);
                int bgWidth = this.computeBackgroundWidth(entry);
                int bgHeight = this.computeBackgroundHeight(entry);
                guiGraphics.method_25294(bgX, bgY, bgX + bgWidth, bgY + bgHeight, 1728042752);
            }
        }
    }

    protected void renderEntryBackground(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int minX = this.method_46426() - this.rowGap;
        int minY = this.method_46427() - 2;
        int maxX = this.method_55442() + 6;
        int maxY = this.method_55443() + 2;
        guiGraphics.method_44379(minX, minY, maxX, maxY);
        this.renderSearchBackground(guiGraphics);
        AbstractEntry entry = (AbstractEntry)this.method_25308(mouseX, mouseY);
        if (entry == null) {
            this.hoveredBackground.reset();
        } else {
            int x = this.computeBackgroundX(entry);
            int y = this.computeBackgroundY(entry);
            int width = this.computeBackgroundWidth(entry);
            int height = this.computeBackgroundHeight(entry);
            this.hoveredBackground.render(guiGraphics, x, y, width, height, partialTick);
        }
        guiGraphics.method_44380();
    }

    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderEntryBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void method_57715(@NotNull class_332 guiGraphics) {
    }

    protected void method_57713(@NotNull class_332 guiGraphics) {
    }

    private class WidgetEntry
    extends AbstractEntry {
        private final class_339 widget;

        private WidgetEntry(class_339 widget) {
            super(OptionsListWidget.this, widget.method_25369());
            this.widget = this.addChild(widget);
        }

        @Override
        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.widget.method_55445(width, height - OptionsListWidget.this.rowGap);
            this.widget.method_48229(left, top);
            super.method_25343(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
        }
    }

    private class ToggleEntry
    extends AbstractEntry {
        protected static final int BUTTON_WIDTH = 40;
        private static final int LABEL_COLOR = -1;
        private static final int DISABLED_COLOR = -5592406;
        private final ButtonWidget button;
        private final Consumer<Boolean> onToggle;
        @Nullable
        private final Prefix prefix;
        protected boolean value;

        private ToggleEntry(@NotNull boolean value, @NotNull Consumer<Boolean> onToggle, @Nullable class_2561 label, @Nullable Prefix prefix, class_7919 tooltip, boolean active) {
            super(OptionsListWidget.this, label);
            this.value = value;
            this.onToggle = onToggle;
            this.button = new ButtonWidget(this.getRight() - 40, this.getY(), 40, 20, value ? class_5244.field_24332 : class_5244.field_24333, this::onPress);
            this.button.method_47400(tooltip);
            this.button.field_22763 = active;
            this.prefix = prefix;
            this.addChild(this.button);
        }

        protected void onPress(class_4185 button) {
            this.value = !this.value;
            this.button.method_25355(this.value ? class_5244.field_24332 : class_5244.field_24333);
            this.onToggle.accept(this.value);
        }

        protected void renderLabel(@NotNull class_332 guiGraphics) {
            int marginX = 0;
            if (this.prefix != null && (marginX = this.prefix.render(guiGraphics, OptionsListWidget.this.font, this.getX(), this.getY(), this.getHeight())) > 0) {
                marginX += OptionsListWidget.this.rowGap;
            }
            int startX = this.getX() + marginX;
            int startY = this.getY();
            int endX = this.button.method_46426() - OptionsListWidget.this.rowGap;
            int endY = this.getBottom();
            int color = this.value ? -1 : -5592406;
            DrawUtil.drawScrollableTextLeftAlign(guiGraphics, OptionsListWidget.this.font, this.label, startX, startY, endX, endY, color);
        }

        @Override
        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.button.method_48229(this.getRight() - this.button.method_25368(), top);
            this.renderLabel(guiGraphics);
            super.method_25343(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
        }
    }

    @FunctionalInterface
    public static interface Prefix {
        public int render(@NotNull class_332 var1, class_327 var2, int var3, int var4, int var5);
    }

    private class ToggleableSliderEntry
    extends ToggleEntry {
        private final SliderWidget slider;

        private ToggleableSliderEntry(SliderWidget slider, @NotNull boolean value, @Nullable Consumer<Boolean> onToggle, class_7919 tooltip, boolean active) {
            super(value, onToggle, slider.method_25369(), null, tooltip, active);
            this.slider = slider;
            this.slider.field_22763 = value;
            this.addChild(this.slider);
        }

        @Override
        protected void onPress(class_4185 button) {
            super.onPress(button);
            this.slider.field_22763 = this.value;
        }

        @Override
        protected void renderLabel(@NotNull class_332 guiGraphics) {
        }

        @Override
        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.method_25343(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
            this.slider.method_25358(width - 40 - OptionsListWidget.this.rowGap);
            this.slider.method_48229(left, top);
            this.slider.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected abstract class AbstractEntry
    extends AbstractListWidget.Entry {
        protected final class_2561 label;
        private final String indexedLabel;
        private final List<class_339> children = new ArrayList<class_339>();

        protected AbstractEntry(OptionsListWidget this$0, class_2561 label) {
            this.label = label;
            this.indexedLabel = label.getString().toLowerCase();
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            for (class_339 child : this.children) {
                child.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        protected <T extends class_339> T addChild(T child) {
            this.children.add(child);
            return child;
        }

        @NotNull
        public List<class_339> method_25396() {
            return this.children;
        }

        @NotNull
        public List<class_339> method_37025() {
            return this.children;
        }
    }
}

