/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.gui.MouseEvent;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderWidget
extends class_357 {
    private final Consumer<Double> listener;
    private final class_2561 prefix;
    @Nullable
    private final class_2561 suffix;
    @Nullable
    private final TextMapper textMapper;
    @Nullable
    private final MouseEventListener mouseEventListener;
    private final double min;
    private final double max;
    private final double step;
    private double mappedValue;
    private double previousAppliedValue;

    public SliderWidget(int x, int y, int width, int height, double mappedValue, double min, double max, double step, @NotNull Consumer<Double> listener, @NotNull class_2561 prefix, @Nullable class_2561 suffix, @Nullable TextMapper textMapper, @Nullable MouseEventListener mouseEventListener) {
        super(x, y, width, height, prefix, mappedValue);
        this.listener = listener;
        this.prefix = prefix;
        this.suffix = suffix;
        this.textMapper = textMapper;
        this.min = min;
        this.max = max;
        this.step = step;
        this.mappedValue = mappedValue;
        this.mouseEventListener = mouseEventListener;
        this.field_22753 = this.unmapValue(this.mappedValue);
        this.mapValue();
        this.method_25346();
        this.previousAppliedValue = this.mappedValue;
    }

    public SliderWidget(double mappedValue, double min, double max, double step, @NotNull Consumer<Double> listener, @NotNull class_2561 prefix, @Nullable class_2561 suffix, @Nullable TextMapper textMapper, @Nullable MouseEventListener mouseEventListener) {
        this(0, 0, 150, 20, mappedValue, min, max, step, listener, prefix, suffix, textMapper, mouseEventListener);
    }

    public SliderWidget(double mappedValue, double min, double max, double step, @NotNull Consumer<Double> listener, @NotNull class_2561 prefix, @Nullable class_2561 suffix) {
        this(0, 0, 150, 20, mappedValue, min, max, step, listener, prefix, suffix, null, null);
    }

    protected void method_25346() {
        class_2561 mappedText;
        class_5250 label = this.prefix.method_27661().method_27693(": ");
        class_5250 message = null;
        if (this.textMapper != null && (mappedText = this.textMapper.getText(this.mappedValue)) != null) {
            message = label.method_10852(mappedText);
        }
        if (message == null) {
            String formatted = String.format(this.step % 1.0 == 0.0 ? "%.0f" : "%.2f", this.mappedValue);
            message = label.method_27693(formatted);
            if (this.suffix != null) {
                message.method_10852(this.suffix);
            }
        }
        this.method_25355((class_2561)message);
    }

    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
        this.sendMouseEvent(MouseEvent.CLICK);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        super.method_25349(mouseX, mouseY, dragX, dragY);
        this.sendMouseEvent(MouseEvent.DRAG);
    }

    public void method_25357(double mouseX, double mouseY) {
        super.method_25357(mouseX, mouseY);
        this.method_25365(false);
        this.sendMouseEvent(MouseEvent.RELEASE);
    }

    private void sendMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseEventListener != null) {
            this.mouseEventListener.onMouseEvent(this, mouseEvent, this.mappedValue);
        }
    }

    protected void method_25344() {
        this.mapValue();
        if (this.previousAppliedValue != this.mappedValue) {
            this.previousAppliedValue = this.mappedValue;
            this.listener.accept(this.mappedValue);
        }
    }

    private double unmapValue(double mappedValue) {
        double clampedValue = Math.max(this.min, Math.min(mappedValue, this.max));
        return (clampedValue - this.min) / (this.max - this.min);
    }

    private void mapValue() {
        double scaledValue = this.min + this.field_22753 * (this.max - this.min);
        this.mappedValue = (double)Math.round(scaledValue / this.step) * this.step;
    }

    public double getMappedValue() {
        return this.mappedValue;
    }

    public void applyMappedValue(double translatedValue) {
        this.field_22753 = this.unmapValue(translatedValue);
        this.method_25344();
        this.method_25346();
    }

    public class_2561 getPrefix() {
        return this.prefix;
    }

    @FunctionalInterface
    public static interface TextMapper {
        @Nullable
        public class_2561 getText(double var1);
    }

    @FunctionalInterface
    public static interface MouseEventListener {
        public void onMouseEvent(@NotNull SliderWidget var1, @NotNull MouseEvent var2, double var3);
    }
}

