package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;

import static org.lwjgl.glfw.GLFW.*;

sealed interface CursorRenderer permits CursorRenderer.Native, CursorRenderer.Virtual {
    void setCursor(@NotNull Cursor cursor);

    void resetCursor();

    void render(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY);

    final class Native implements CursorRenderer {
        Native() {
        }

        @Override
        public void setCursor(@NotNull Cursor cursor) {
            glfwSetCursor(CursorTypeUtil.WINDOW, cursor.getId());
        }

        @Override
        public void resetCursor() {
            glfwSetCursor(CursorTypeUtil.WINDOW, MemoryUtil.NULL);
        }

        @Override
        public void render(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
            // no-op
        }
    }

    final class Virtual implements CursorRenderer {
        private static final float Z = 5000f;
        private class_2960 textureLocation;
        private int textureWidth;
        private int textureHeight;
        private int vOffset;
        private double xhot;
        private double yhot;
        private double size;

        Virtual() {
        }

        @Override
        public void setCursor(@NotNull Cursor cursor) {
            this.textureLocation = cursor.getLocation();
            this.textureWidth = cursor.getTextureWidth();
            this.textureHeight = cursor.getTextureHeight();
            this.vOffset = this.textureWidth * cursor.getTextureIndex();

            double scale = SettingsUtil.getAutoScale(cursor.getScale());
            this.xhot = cursor.getXHot() * scale;
            this.yhot = cursor.getYHot() * scale;
            this.size = this.textureWidth * scale;
        }

        @Override
        public void resetCursor() {
            glfwSetInputMode(CursorTypeUtil.WINDOW, GLFW_CURSOR, GLFW_CURSOR_NORMAL);
            this.textureLocation = null;
        }

        @Override
        public void render(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
            if (!minecraft.field_1729.method_1613() && this.textureLocation != null) {
                int guiScale = (int) minecraft.method_22683().method_4495();
                int scaledSize = (int) Math.round(this.size / guiScale);
                int x = mouseX - (int) Math.round(this.xhot / guiScale);
                int y = mouseY - (int) Math.round(this.yhot / guiScale);

                glfwSetInputMode(CursorTypeUtil.WINDOW, GLFW_CURSOR, GLFW_CURSOR_HIDDEN);

                class_4587 poseStack = guiGraphics.method_51448();

                poseStack.method_22903();
                poseStack.method_46416(0f,0f, Z);
                guiGraphics.method_25293(
                        this.textureLocation,
                        x, y,
                        scaledSize, scaledSize,
                        0, this.vOffset,
                        this.textureWidth, this.textureWidth,
                        this.textureWidth, this.textureHeight
                );
                poseStack.method_22909();
            }
        }
    }
}
