package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorResourceLoader;
import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.*;
import io.github.fishstiz.minecraftcursor.gui.widget.ContainerEventHandlerPatch;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_8021;

public class ConfigurationScreen extends CatalogBrowserScreen implements ContainerEventHandlerPatch {
    private static final class_2561 GLOBAL_TEXT = class_2561.method_43471("minecraft-cursor.options.global");
    private static final class_2561 ADAPTIVE_TEXT = class_2561.method_43471("minecraft-cursor.options.adapt");
    private static final class_2561 COMPAT_TEXT = class_2561.method_43471("minecraft-cursor.options.compat");
    private static final class_2561 CURSORS_TEXT = class_2561.method_43471("minecraft-cursor.options.cursor-types");
    private static final class_2561 DEBUG_TEXT = class_2561.method_43471("minecraft-cursor.options.debug");
    private static final int SPACING = 8;
    private static final int HEADER_HEIGHT = 20;
    private static final int SIDEBAR_WIDTH = 140;
    private static final int MAX_CONTENT_WIDTH = 128 * 2 + SPACING;
    private static final int LIST_CURSOR_SIZE = 16;
    private static final int BUSY_OVERRIDE = -10;
    private static final CatalogItem GLOBAL_CATEGORY = new CatalogItem("global", GLOBAL_TEXT);
    private static final CatalogItem CURSORS_CATEGORY = new CatalogItem("cursors", CURSORS_TEXT);
    private final CursorAnimationHelper animationHelper = new CursorAnimationHelper();
    private CatalogItem defaultItem;
    private CompletableFuture<Void> refreshFuture;

    public ConfigurationScreen(class_437 previous) {
        super(class_2561.method_43471("minecraft-cursor.options"), HEADER_HEIGHT, SIDEBAR_WIDTH, MAX_CONTENT_WIDTH, SPACING, previous);
    }

    @Override
    public void method_49589() {
        for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
            if (cursor.isLazy()) {
                CursorResourceLoader.loadCursorTexture(cursor);
            }
        }
    }

    @Override
    public void method_25419() {
        if (this.refreshFuture != null) {
            this.refreshFuture.join();
        }

        CursorController.getInstance().removeOverride(BUSY_OVERRIDE);
        MinecraftCursor.CONFIG.save();
        super.method_25419();
    }

    @Override
    protected void initItems() {
        this.addGlobalItems();
        this.addAdaptiveItems();
        this.addCursorItems();
        this.addCompatibilityItems();
        this.addDebugItems();
    }

    @Override
    protected void postInit() {
        this.selectItem(this.defaultItem);
    }

    @Override
    protected void refreshItemsAndPanel() {
        if (this.refreshFuture != null && !this.refreshFuture.isDone()) {
            return;
        }

        this.getRefreshButton().field_22763 = false;
        CursorController.getInstance().overrideCursor(CursorType.BUSY, BUSY_OVERRIDE);
        this.refreshFuture = CompletableFuture.runAsync(CursorResourceLoader::reload, class_156.method_18349())
                .thenRunAsync(
                        () -> {
                            this.addCursorItems();
                            super.refreshItemsAndPanel();
                            this.getRefreshButton().field_22763 = true;
                            CursorController.getInstance().removeOverride(BUSY_OVERRIDE);
                        },
                        this.field_22787
                );
    }

    private void addGlobalItems() {
        this.addCategoryOnly(GLOBAL_CATEGORY, new GlobalOptionsPanel(this::refreshCursors));
    }

    private void addAdaptiveItems() {
        this.addCategoryOnly(new CatalogItem("adaptive", ADAPTIVE_TEXT), new AdaptiveOptionsPanel(ADAPTIVE_TEXT, this.animationHelper, this::refreshCursors));
    }

    private void addCompatibilityItems() {
        this.addCategoryOnly(new CatalogItem("compatibility", COMPAT_TEXT), new CompatibilityOptionsPanel(COMPAT_TEXT));
    }

    private void addCursorItems() {
        for (CatalogItem cursorItem : this.createCursorItems()) {
            if (CursorType.DEFAULT.getKey().equals(cursorItem.id())) {
                this.defaultItem = cursorItem;
            }

            this.addOrUpdateItem(CURSORS_CATEGORY, cursorItem, new CursorOptionsPanel(
                    this.animationHelper,
                    this::refreshCursors,
                    GLOBAL_CATEGORY,
                    Objects.requireNonNull(CursorManager.INSTANCE.getCursor(cursorItem.id()))
            ));
        }
    }

    private void addDebugItems() {
        this.addCategoryOnly(new CatalogItem("debug", DEBUG_TEXT), new DebugOptionsPanel(DEBUG_TEXT));
    }

    private int renderListCursor(class_332 guiGraphics, class_327 font, CatalogItem item, class_8021 bounds, int spacing, int mouseX, int mouseY, float partialTick) {
        Cursor cursor = CursorManager.INSTANCE.getCursor(item.id());

        if (cursor != null && cursor.isLoaded()) {
            int prefixX = bounds.method_46426() + spacing;
            int prefixY = bounds.method_46427() + (bounds.method_25364() - LIST_CURSOR_SIZE) / 2;
            this.animationHelper.drawSprite(guiGraphics, cursor, prefixX, prefixY, LIST_CURSOR_SIZE);
        }

        return LIST_CURSOR_SIZE;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        return ContainerEventHandlerPatch.super.method_25406(mouseX, mouseY, button);
    }

    private void refreshCursors() {
        this.addCursorItems();
        this.refreshItems();
    }

    private List<CatalogItem> createCursorItems() {
        return CursorManager.INSTANCE.getCursors()
                .stream()
                .map(cursor -> new CatalogItem(
                        cursor.getTypeKey(),
                        cursor.getText().method_27661().method_27692(getCursorFormat(cursor)),
                        this::renderListCursor
                ))
                .toList();
    }

    private static class_124 getCursorFormat(@NotNull Cursor cursor) {
        if (cursor.isEnabled()) {
            return class_124.field_1068;
        }
        if (cursor.isLoaded()) {
            return class_124.field_1080;
        }
        return class_124.field_1063;
    }
}
