package io.github.fishstiz.minecraftcursor.gui.screen.panel;

import io.github.fishstiz.minecraftcursor.CursorResourceLoader;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CatalogBrowserScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.ContainerEventHandlerPatch;
import net.minecraft.class_2561;
import net.minecraft.class_370;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractOptionsPanel extends CatalogBrowserScreen.ContentPanel implements ContainerEventHandlerPatch {
    protected static final class_2561 ENABLE_TEXT = class_2561.method_43471("minecraft-cursor.options.enabled");
    protected static final class_2561 SCALE_TEXT = class_2561.method_43471("minecraft-cursor.options.scale");
    protected static final class_2561 GUI_SCALE_TEXT = class_2561.method_43471("minecraft-cursor.options.scale.gui");
    protected static final class_2561 XHOT_TEXT = class_2561.method_43471("minecraft-cursor.options.xhot");
    protected static final class_2561 YHOT_TEXT = class_2561.method_43471("minecraft-cursor.options.yhot");
    protected static final class_2561 HOTSPOT_SUFFIX = class_2561.method_43471("minecraft-cursor.options.hotspot-suffix");
    private final class_2561 title;
    private class_7842 titleWidget;

    protected AbstractOptionsPanel(class_2561 title) {
        this.title = withBold(title);
    }

    protected abstract void initContents();

    protected abstract void repositionContents(int x, int y);

    @Override
    protected final void init() {
        this.titleWidget = new class_7842(this.getHeaderWidth(), this.getHeaderHeight(), this.title, this.getFont()).method_48596();
        this.addRenderableIndexedWidget(this.titleWidget);
        this.initContents();
    }

    @Override
    protected final void repositionElements() {
        this.titleWidget.method_25358(this.getHeaderWidth());
        this.titleWidget.method_48229(this.getX(), this.getY());

        this.repositionContents(this.getX(), this.getY() + this.titleWidget.method_25364() + this.getSpacing());
    }

    protected int computeMaxHeight(int top) {
        return Math.max(0, this.getHeight() - (top - this.getY()));
    }

    protected boolean loadCursor(@NotNull Cursor deferredCursor) {
        if (deferredCursor.isLoaded()) {
            throw new IllegalStateException("Cursor is already loaded");
        }
        if (CursorResourceLoader.loadCursorTexture(this.getMinecraft().method_1478(), deferredCursor)) {
            return true;
        }
        this.getMinecraft().method_1566().method_1999(class_370.method_29047(
                this.getMinecraft(),
                class_370.class_371.field_21809,
                class_2561.method_43471("resourcePack.load_fail"),
                class_2561.method_43469("minecraft-cursor.options.global.deferred_loading.fail", deferredCursor.getText())
        ));
        return false;
    }

    protected void refreshWidgets() {
        this.clearWidgets();
        this.init();
    }

    @Override
    protected void added() {
        this.refreshWidgets();
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        return ContainerEventHandlerPatch.super.method_25406(mouseX, mouseY, button);
    }

    private static class_5250 withBold(class_2561 text) {
        return text.method_27661().method_27694(style -> style.method_10982(true));
    }
}
