package io.github.fishstiz.minecraftcursor.gui.screen.panel;

import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.gui.widget.OptionsListWidget;
import net.minecraft.class_2561;
import net.minecraft.class_7919;
import io.github.fishstiz.minecraftcursor.config.Flag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.CONFIG;

public class CompatibilityOptionsPanel extends AbstractOptionsPanel {
    private static final class_2561 AGGRESSIVE_TEXT = class_2561.method_43471("minecraft-cursor.options.compat.aggressive_cursor");
    private static final class_7919 AGGRESSIVE_INFO = class_7919.method_47407(class_2561.method_43471("minecraft-cursor.options.compat.aggressive_cursor.info"));
    private static final class_2561 REMAP_TEXT = class_2561.method_43471("minecraft-cursor.options.compat.remap_cursors");
    private static final class_7919 REMAP_INFO = class_7919.method_47407(class_2561.method_43471(Flag.REMAP.getInfoKey()));
    private static final class_7919 REMAP_EMPTY_INFO = class_7919.method_47407(class_2561.method_43471("minecraft-cursor.options.compat.remap_cursors.empty"));
    private static final class_2561 VIRTUAL_TEXT = class_2561.method_43471("minecraft-cursor.options.compat.virtual_mode");
    private static final class_7919 VIRTUAL_INFO = class_7919.method_47407(class_2561.method_43471("minecraft-cursor.options.compat.virtual_mode.info"));
    private OptionsListWidget optionsList;

    public CompatibilityOptionsPanel(class_2561 title) {
        super(title);
    }

    @Override
    protected void initContents() {
        this.optionsList = new OptionsListWidget(this.getMinecraft(), this.getFont(), this.getSpacing());

        this.optionsList.addToggle(
                CONFIG.isAggressiveCursor(),
                CONFIG::setAggressiveCursor,
                this.index(AGGRESSIVE_TEXT),
                AGGRESSIVE_INFO,
                true
        );
        this.optionsList.addToggle(
                CursorManager.INSTANCE.isVirtual(),
                value -> {
                    CursorManager.INSTANCE.toggleVirtual();
                    CONFIG.setVirtualMode(CursorManager.INSTANCE.isVirtual());
                },
                this.index(VIRTUAL_TEXT),
                VIRTUAL_INFO,
                true
        );
        this.optionsList.addToggle(
                Flag.REMAP.isEnabled() && CONFIG.isRemapCursorsEnabled(),
                CONFIG::setRemapCursorsEnabled,
                this.index(REMAP_TEXT),
                !Flag.REMAP.isEnabled() || ExternalCursorTracker.isTracking() ? REMAP_INFO : REMAP_EMPTY_INFO,
                Flag.REMAP.isEnabled()
        );

        this.optionsList.search(this.getSearch());

        this.addRenderableWidget(this.optionsList);
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.optionsList != null) {
            this.optionsList.setSize(this.getWidth(), this.computeMaxHeight(y));
            this.optionsList.method_48229(x, y);
        }
    }

    @Override
    protected void searched(@NotNull String search, @Nullable class_2561 matched) {
        if (this.optionsList != null) {
            this.optionsList.search(search);
        }
    }
}
