package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorPreviewWidget extends CursorWidget {
    private static final class_2960 BACKGROUND_128 = MinecraftCursor.loc("textures/gui/background_dark_128.png");
    private static final class_2561 PREVIEW_TEXT = class_2561.method_43471("minecraft-cursor.options.preview");
    private static final int PREVIEW_TEXT_OFFSET = 4;
    private static final int PREVIEW_TEXT_COLOR = 0x7FFFFFFF; // 50% white
    private static final int RULER_COLOR = 0xFF00FF00; // green
    private static final int BACKGROUND_DISABLED = 0x7F000000; // 50% black
    private static final int DEFAULT_BUTTON_SIZE = 20;
    private final @Nullable class_4185 button;
    private final class_327 font;

    public CursorPreviewWidget(@NotNull Cursor cursor, @NotNull class_327 font, @Nullable class_4185 button) {
        super(class_5244.field_39003, cursor, BACKGROUND_128);

        this.field_22763 = false;
        this.font = font;
        this.button = button;
    }

    public CursorPreviewWidget(@NotNull Cursor cursor, @NotNull class_327 font) {
        this(cursor, font, class_4185.method_46430(class_5244.field_39003, b -> b.method_25365(false))
                .method_46437(DEFAULT_BUTTON_SIZE, DEFAULT_BUTTON_SIZE)
                .method_46431()
        );
    }

    @Override
    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        Cursor cursor = this.getCursor();

        if (cursor.isLoaded()) {
            this.renderBackground(guiGraphics);
            if (cursor.isEnabled()) {
                this.renderPreviewText(guiGraphics);
                this.renderTestButton(guiGraphics, mouseX, mouseY, partialTick);
                this.renderRuler(guiGraphics, mouseX, mouseY);
            }
        }
        if (!cursor.isEnabled()) {
            guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.getRight(), this.getBottom(), BACKGROUND_DISABLED);
        }

        this.renderBorder(guiGraphics);
    }

    protected void renderPreviewText(@NotNull class_332 guiGraphics) {
        int width = this.font.method_27525(PREVIEW_TEXT);
        int endX = this.getRight() - PREVIEW_TEXT_OFFSET;
        int endY = this.getBottom() - PREVIEW_TEXT_OFFSET;
        int startX = endX - width;
        int startY = endY - this.font.field_2000;
        DrawUtil.drawScrollableTextLeftAlign(guiGraphics, this.font, PREVIEW_TEXT, startX, startY, endX, endY, PREVIEW_TEXT_COLOR, false);
        guiGraphics.method_51452();
    }

    protected void renderTestButton(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.button != null) {
            int buttonX = this.method_46426() + (this.method_25368() / 2 - this.button.method_25368() / 2);
            int buttonY = this.method_46427() + (this.method_25364() / 2 - this.button.method_25364() / 2);
            this.button.method_48229(buttonX, buttonY);
            this.button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected void renderRuler(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            guiGraphics.method_25292(this.method_46426(), this.getRight() - 1, mouseY, RULER_COLOR);
            guiGraphics.method_25301(mouseX, method_46427(), this.getBottom(), RULER_COLOR);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.button != null && this.button.method_25405(mouseX, mouseY)) {
            this.button.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764
               && mouseX >= (double) this.method_46426()
               && mouseY >= (double) this.method_46427()
               && mouseX < (double) this.getRight()
               && mouseY < (double) this.getBottom();
    }

    @Override
    public CursorType getCursorType(double mouseX, double mouseY) {
        return this.getCursor().getType();
    }
}
