package io.github.fishstiz.minecraftcursor.mixin;

import io.github.fishstiz.minecraftcursor.gui.screen.ConfigurationScreen;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_339;
import net.minecraft.class_353;
import net.minecraft.class_4288;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_7172;

@Mixin(class_4288.class)
public abstract class MouseOptionsScreenMixin extends class_4667 {
    @Unique
    private static final class_2561 SETTINGS_TEXT = class_2561.method_43471("minecraft-cursor.options").method_10852(class_5244.field_39678);

    @Shadow
    private class_353 list;

    protected MouseOptionsScreenMixin(class_437 parent, class_315 gameOptions, class_2561 title) {
        super(parent, gameOptions, title);
    }

    @Inject(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/MouseSettingsScreen;addWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;"))
    public void addButtonOnInit(CallbackInfo ci) {
        var settingsOption = minecraft_cursor$createDummyOption(() -> Objects.requireNonNull(this.field_22787).method_1507(new ConfigurationScreen(this)));
        var fillerOption = minecraft_cursor$createDummyOption(null);
        list.method_20407(settingsOption, fillerOption);

        class_339 fillerButton = list.method_31046(fillerOption);
        class_339 settingsButton = list.method_31046(settingsOption);

        if (settingsButton != null && fillerButton != null) {
            settingsButton.method_25355(SETTINGS_TEXT);
            fillerButton.method_25355(class_5244.field_39003);
            fillerButton.field_22763 = false;
            fillerButton.field_22764 = false;
        }
    }

    @Unique
    private static class_7172<Boolean> minecraft_cursor$createDummyOption(@Nullable Runnable runnable) {
        return class_7172.method_41751("", false, runnable != null
                ? value -> runnable.run()
                : value -> {}
        );
    }
}
