package io.github.fishstiz.minecraftcursor.mixin.cursorhandler;

import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.handler.InternalCursorProvider;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.*;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.CONFIG;

@Mixin(class_465.class)
public abstract class AbstractContainerScreenMixin<T extends class_1703> extends class_437 implements InternalCursorProvider {
    @Shadow @Final protected T menu;

    @Shadow @Nullable protected class_1735 hoveredSlot;

    @Shadow protected int imageHeight;

    protected AbstractContainerScreenMixin(class_2561 title) {
        super(title);
    }

    @Override
    public @NotNull CursorType minecraft_cursor$getCursorType(double mouseX, double mouseY) {
        boolean canClickFocusedSlot = menu.method_34255().method_7960()
                                      && hoveredSlot != null
                                      && hoveredSlot.method_7681()
                                      && hoveredSlot.method_51306();

        if (canClickFocusedSlot && CursorTypeUtil.canShift()) {
            return CursorType.SHIFT;
        }
        if (CONFIG.isItemSlotEnabled() && canClickFocusedSlot) {
            return CursorType.POINTER;
        }
        if (CONFIG.isItemGrabbingEnabled() && !menu.method_34255().method_7960()) {
            return CursorType.GRABBING;
        }
        return CursorType.DEFAULT;
    }
}
