package io.github.fishstiz.minecraftcursor.mixin.cursorhandler;

import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.mixin.cursorhandler.access.*;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_1729;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_361;
import net.minecraft.class_479;
import net.minecraft.class_489;
import net.minecraft.class_490;
import net.minecraft.class_507;
import net.minecraft.class_508;
import net.minecraft.class_512;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value = {class_490.class, class_479.class, class_489.class})
public abstract class AbstractRecipeBookScreenMixin extends AbstractContainerScreenMixin<class_1729<?>> {
    protected AbstractRecipeBookScreenMixin(class_2561 title) {
        super(title);
    }

    @Override
    public @NotNull CursorType minecraft_cursor$getCursorType(double mouseX, double mouseY) {
        class_507 recipeBookComponent = this.minecraft_cursor$getRecipeBook();
        if (recipeBookComponent != null && recipeBookComponent.method_2605()) {
            RecipeBookWidgetAccessor recipeBook = (RecipeBookWidgetAccessor) recipeBookComponent;
            RecipeBookResultsAccessor recipesArea = (RecipeBookResultsAccessor) recipeBook.getRecipesArea();
            RecipeAlternativesWidgetAccessor alternatesWidget = (RecipeAlternativesWidgetAccessor) recipesArea.getAlternatesWidget();

            if (((class_508) alternatesWidget).method_2616()) {
                return minecraft_cursor$getAlternatesWidgetCursor(alternatesWidget);
            }

            boolean isResultHovered = recipesArea.getHoveredResultButton() != null;
            if (isResultHovered && CursorTypeUtil.canShift()) {
                return CursorType.SHIFT;
            } else if (this.minecraft_cursor$isButtonHovered(recipeBook, recipesArea) || isResultHovered) {
                return CursorType.POINTER;
            } else if (recipeBook.getSearchField().method_49606()) {
                return CursorType.TEXT;
            }

            CursorType tabCursorType = this.minecraft_cursor$getTabCursor(recipeBook);
            if (!tabCursorType.isDefault()) {
                return tabCursorType;
            }
        }

        return super.minecraft_cursor$getCursorType(mouseX, mouseY);
    }

    @Unique
    private @Nullable class_507 minecraft_cursor$getRecipeBook() {
        if ((Object) this instanceof class_490 inventoryScreen) {
            return inventoryScreen.method_2659();
        } else if ((Object) this instanceof class_479 craftingScreen) {
            return craftingScreen.method_2659();
        } else if ((Object) this instanceof class_489<?> furnaceScreen) {
            return furnaceScreen.method_2659();
        }
        return null;
    }

    @Unique
    private CursorType minecraft_cursor$getAlternatesWidgetCursor(RecipeAlternativesWidgetAccessor alternatesWidget) {
        for (class_339 alternativeButton : alternatesWidget.getAlternativeButtons()) {
            if (alternativeButton.method_37303() && alternativeButton.method_49606()) {
                return CursorTypeUtil.canShift() ? CursorType.SHIFT : CursorType.POINTER;
            }
        }
        return CursorType.DEFAULT_FORCE;
    }

    @Unique
    private boolean minecraft_cursor$isButtonHovered(RecipeBookWidgetAccessor recipeBook, RecipeBookResultsAccessor recipesArea) {
        class_361 prevPageButton = recipesArea.getPrevPageButton();
        class_361 nextPageButton = recipesArea.getNextPageButton();
        class_361 toggleCraftableButton = recipeBook.getToggleCraftableButton();

        return (toggleCraftableButton.field_22764 && toggleCraftableButton.method_49606()) ||
               (prevPageButton.field_22764 && prevPageButton.method_49606()) ||
               (nextPageButton.field_22764 && nextPageButton.method_49606());
    }

    @Unique
    private CursorType minecraft_cursor$getTabCursor(RecipeBookWidgetAccessor recipeBook) {
        for (class_512 tabButton : recipeBook.getTabButtons()) {
            if (tabButton.method_49606() && tabButton.method_37303() && tabButton != recipeBook.getCurrentTab()) {
                return CursorType.POINTER;
            }
        }
        return CursorType.DEFAULT;
    }
}
