package io.github.fishstiz.minecraftcursor.mixin.cursorhandler;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3872;
import net.minecraft.class_473;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(class_473.class)
public abstract class BookEditScreenMixin {
    @Shadow
    @Final
    private static int TEXT_WIDTH;

    @Shadow
    @Final
    private static int TEXT_HEIGHT;

    @Shadow
    private boolean isSigning;

    @Unique
    private static final int minecraft_cursor$TEXT_OFFSET_X = 36;

    @Unique
    private static final int minecraft_cursor$TEXT_OFFSET_Y = 28;

    @ModifyArg(method = "render", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIII)V",
            ordinal = 0
    ))
    private class_2960 setTextCursorOnHover(class_2960 resourceLocation, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        if (MinecraftCursor.CONFIG.isBookEditEnabled() && !this.isSigning && resourceLocation == class_3872.field_17117) {
            var minecraft = class_310.method_1551();
            var window = minecraft.method_22683();
            double mouseX = minecraft.field_1729.method_1603() * window.method_4486() / window.method_4480();
            double mouseY = minecraft.field_1729.method_1604() * window.method_4502() / window.method_4507();

            int left = x + minecraft_cursor$TEXT_OFFSET_X;
            int top = y + minecraft_cursor$TEXT_OFFSET_Y;
            int right = left + TEXT_WIDTH;
            int bottom = top + TEXT_HEIGHT;

            if (mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom) {
                CursorController.getInstance().setSingleCycleFallbackCursor(CursorType.TEXT);
            }
        }
        return resourceLocation;
    }
}
