package io.github.fishstiz.minecraftcursor.mixin.cursorhandler;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_1726;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_494;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_494.class)
public abstract class LoomScreenMixin extends AbstractContainerScreenMixin<class_1726> {
    @Unique
    private static final int minecraft_cursor$HIGHLIGHTED_V_OFFSET = 28;

    @Shadow
    private boolean scrolling;

    @Shadow
    @Final
    private static class_2960 BG_LOCATION;

    protected LoomScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method = "renderBg", at = @At("RETURN"))
    private void forceDefaultOnScroll(class_332 guiGraphics, float partialTick, int mouseX, int mouseY, CallbackInfo ci) {
        if (this.scrolling && CursorTypeUtil.isLeftClickHeld()) {
            CursorController.getInstance().setSingleCycleCursor(CursorType.DEFAULT_FORCE);
        }
    }

    @ModifyArg(
            method = "renderBg",
            slice = @Slice(from = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/inventory/LoomMenu;getSelectablePatterns()Ljava/util/List;"
            )),
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIII)V"
            )
    )
    private class_2960 setPointerOnHover(class_2960 resourceLocation, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        if (MinecraftCursor.CONFIG.isLoomPatternsEnabled()
            && resourceLocation == BG_LOCATION
            && vOffset == this.imageHeight + minecraft_cursor$HIGHLIGHTED_V_OFFSET) {
            CursorController.getInstance().setSingleCycleFallbackCursor(CursorType.POINTER);
        }
        return resourceLocation;
    }
}
