package io.github.fishstiz.minecraftcursor.mixin.cursorhandler;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.handler.InternalCursorProvider;
import io.github.fishstiz.minecraftcursor.mixin.cursorhandler.access.OnlineServerEntryAccessor;
import net.minecraft.class_310;
import net.minecraft.class_4267;
import net.minecraft.class_4280;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_4267.class)
public abstract class ServerSelectionListMixin extends class_4280<class_4267.class_504> implements InternalCursorProvider {
    @Unique
    private static final int minecraft_cursor$ICON_WIDTH = 32;

    @Unique
    private static final int minecraft_cursor$MOVE_ICON_SIZE = 16;

    protected ServerSelectionListMixin(class_310 minecraft, int width, int height, int y0, int y1, int itemHeight) {
        super(minecraft, width, height, y0, y1, itemHeight);
    }

    @Override
    public @NotNull CursorType minecraft_cursor$getCursorType(double mouseX, double mouseY) {
        if (MinecraftCursor.CONFIG.isServerIconEnabled()
            && mouseX < this.method_25342() + minecraft_cursor$ICON_WIDTH
            && this.method_25308(mouseX, mouseY) instanceof class_4267.class_4270 serverEntry) {
            OnlineServerEntryAccessor accessor = (OnlineServerEntryAccessor) serverEntry;
            int i = this.method_25396().indexOf(serverEntry);
            double relativeX = mouseX - this.method_25342();
            double relativeY = mouseY - this.method_25337(i);

            if (relativeX < minecraft_cursor$ICON_WIDTH && relativeX > minecraft_cursor$MOVE_ICON_SIZE && accessor.invokeCanJoin()) {
                return CursorType.POINTER;
            }
            if (relativeX < minecraft_cursor$MOVE_ICON_SIZE && relativeY < minecraft_cursor$MOVE_ICON_SIZE && i > 0) {
                return CursorType.POINTER;
            }
            if (relativeX < minecraft_cursor$MOVE_ICON_SIZE && relativeY > minecraft_cursor$MOVE_ICON_SIZE && i < accessor.getScreen().method_2529().method_2984() - 1) {
                return CursorType.POINTER;
            }
        }

        return CursorType.DEFAULT;
    }
}
