package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;

import static org.lwjgl.glfw.GLFW.*;

sealed interface CursorRenderer permits CursorRenderer.Native, CursorRenderer.Virtual {
    void setCursor(@NotNull Cursor cursor);

    void resetCursor();

    void render(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY);

    final class Native implements CursorRenderer {
        Native() {
        }

        @Override
        public void setCursor(@NotNull Cursor cursor) {
            glfwSetCursor(CursorTypeUtil.WINDOW, cursor.getId());
        }

        @Override
        public void resetCursor() {
            glfwSetCursor(CursorTypeUtil.WINDOW, MemoryUtil.NULL);
        }

        @Override
        public void render(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
            // no-op
        }
    }

    final class Virtual implements CursorRenderer {
        private class_2960 textureLocation;
        private int textureWidth;
        private int textureHeight;
        private int vOffset;
        private double xhot;
        private double yhot;
        private double size;

        Virtual() {
        }

        @Override
        public void setCursor(@NotNull Cursor cursor) {
            this.textureLocation = cursor.getLocation();
            this.textureWidth = cursor.getTextureWidth();
            this.textureHeight = cursor.getTextureHeight();
            this.vOffset = this.textureWidth * cursor.getTextureIndex();

            double scale = SettingsUtil.getAutoScale(cursor.getScale());
            this.xhot = cursor.getXHot() * scale;
            this.yhot = cursor.getYHot() * scale;
            this.size = this.textureWidth * scale;
        }

        @Override
        public void resetCursor() {
            glfwSetInputMode(CursorTypeUtil.WINDOW, GLFW_CURSOR, GLFW_CURSOR_NORMAL);
            this.textureLocation = null;
        }

        @Override
        public void render(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
            if (!minecraft.field_1729.method_1613() && this.textureLocation != null) {
                int guiScale = minecraft.method_22683().method_4495();
                int scaledSize = (int) Math.round(this.size / guiScale);
                int x = mouseX - (int) Math.round(this.xhot / guiScale);
                int y = mouseY - (int) Math.round(this.yhot / guiScale);

                glfwSetInputMode(CursorTypeUtil.WINDOW, GLFW_CURSOR, GLFW_CURSOR_HIDDEN);

                guiGraphics.method_71048();
                guiGraphics.method_25302(
                        class_10799.field_56883,
                        this.textureLocation,
                        x, y,
                        0, this.vOffset,
                        scaledSize, scaledSize,
                        this.textureWidth, this.textureWidth,
                        this.textureWidth, this.textureHeight
                );
            }
        }
    }
}
